/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.datacomponent.PlayerCompassData;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.items.PlayerStatueSpawnItem;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.registry.StatueTags;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlayerStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty ONLINE = BooleanProperty.create((String)"online");

    public PlayerStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlayerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PlayerStatueBlock.createStatueTicker(level, blockEntityType, StatueBlockEntities.PLAYER.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStatueTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends PlayerBlockEntity> blockEntityType1) {
        return level.isClientSide ? null : PlayerStatueBlock.createTickerHelper(blockEntityType, blockEntityType1, PlayerBlockEntity::serverTick);
    }

    private PlayerBlockEntity getBE(Level level, BlockPos pos) {
        return (PlayerBlockEntity)level.getBlockEntity(pos);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack stack) {
        if (be instanceof PlayerBlockEntity) {
            PlayerBlockEntity blockEntity = (PlayerBlockEntity)be;
            if (((Nameable)be).hasCustomName()) {
                player.causeFoodExhaustion(0.005f);
                if (level.isClientSide) {
                    return;
                }
                if (this == Blocks.AIR) {
                    return;
                }
                ItemStack itemstack = new ItemStack((ItemLike)this);
                itemstack.set(DataComponents.CUSTOM_NAME, (Object)blockEntity.getName());
                blockEntity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
                PlayerStatueBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemstack);
                if (!blockEntity.getComparatorApplied()) return;
                PlayerStatueBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.COMPARATOR.asItem()));
                return;
            }
        }
        super.playerDestroy(level, player, pos, state, null, stack);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (state.hasBlockEntity() && newState.getBlock() != StatueRegistry.PLAYER_STATUE.get()) {
            level.removeBlockEntity(pos);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.getCloneItemStack(level, pos, state);
        level.getBlockEntity(pos, StatueBlockEntities.PLAYER.get()).ifPresent(blockEntity -> blockEntity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess()));
        return itemstack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            MutableComponent userComponent = Component.literal((String)"Username: ").withStyle(ChatFormatting.GOLD);
            userComponent.append((Component)stack.getHoverName().plainCopy().withStyle(ChatFormatting.WHITE));
            components.add((Component)userComponent);
            if (stack.has(DataComponents.PROFILE)) {
                ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
                profile.id().ifPresent(id -> {
                    MutableComponent UUIDComponent = Component.literal((String)"UUID: ").withStyle(ChatFormatting.GOLD);
                    UUIDComponent.append((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.WHITE));
                    components.add((Component)UUIDComponent);
                });
            }
        }
        super.appendHoverText(stack, context, components, flag);
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.getValue((Property)ONLINE)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)ONLINE);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{FACING, WATERLOGGED, ONLINE});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult result) {
        ResolvableProfile tileProfile = this.getBE(level, pos).getPlayerProfile();
        PlayerBlockEntity playerBlockEntity = this.getBE(level, pos);
        if (!level.isClientSide && playerBlockEntity != null && tileProfile != null) {
            boolean onlineFlag;
            String playerName = tileProfile.name().orElse("Unknown");
            UUID id = tileProfile.id().orElse(null);
            boolean bl = onlineFlag = id != null && level.getPlayerByUUID((UUID)tileProfile.id().get()) != null;
            if (playerIn.isShiftKeyDown()) {
                if (playerBlockEntity.getComparatorApplied()) {
                    playerBlockEntity.setComparatorApplied(false);
                    ItemStack comparatorStack = new ItemStack((ItemLike)Items.COMPARATOR);
                    if (!playerIn.addItem(comparatorStack)) {
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), comparatorStack));
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (((Boolean)StatuesConfig.COMMON.playerCompass.get()).booleanValue()) {
                if (stack.getItem() == Items.COMPASS || stack.getItem() == StatueRegistry.PLAYER_COMPASS.get()) {
                    boolean isPlayerCompass;
                    boolean bl2 = isPlayerCompass = stack.getItem() == StatueRegistry.PLAYER_COMPASS.get();
                    if (onlineFlag) {
                        ItemStack playerCompass = isPlayerCompass ? stack : new ItemStack((ItemLike)StatueRegistry.PLAYER_COMPASS.get());
                        Player player = level.getPlayerByUUID(id);
                        if (player != null && player.level().dimension().location().equals((Object)playerIn.level().dimension().location())) {
                            BlockPos playerPos = player.blockPosition();
                            playerCompass.set(StatueDataComponents.PLAYER_COMPASS_DATA.get(), (Object)new PlayerCompassData(playerPos, tileProfile.name().orElse("Unknown")));
                            if (!isPlayerCompass) {
                                stack.consume(1, (LivingEntity)playerIn);
                                if (stack.isEmpty()) {
                                    playerIn.setItemInHand(hand, playerCompass);
                                } else if (!playerIn.getInventory().add(playerCompass)) {
                                    playerIn.drop(playerCompass, false);
                                }
                            }
                        } else {
                            playerIn.sendSystemMessage((Component)Component.translatable((String)"statues.player.compass.dimension.failure", (Object[])new Object[]{String.valueOf(ChatFormatting.GOLD) + playerName}));
                        }
                    } else {
                        playerIn.sendSystemMessage((Component)Component.translatable((String)"statues.player.compass.offline", (Object[])new Object[]{String.valueOf(ChatFormatting.GOLD) + playerName}));
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                if (stack.getItem() == Items.COMPARATOR && !playerBlockEntity.getComparatorApplied()) {
                    stack.consume(1, (LivingEntity)playerIn);
                    playerBlockEntity.setComparatorApplied(true);
                    playerBlockEntity.updateOnline();
                    return ItemInteractionResult.SUCCESS;
                }
                if (stack.is(StatueTags.PLAYER_UPGRADE_ITEM) && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Consumer consumer = EntityType.appendCustomEntityStackConfig(p_263581_ -> {}, (ServerLevel)serverLevel, (ItemStack)stack, (Player)playerIn);
                    PlayerStatue playerStatueEntity = (PlayerStatue)StatueRegistry.PLAYER_STATUE_ENTITY.get().create(serverLevel, consumer, pos, MobSpawnType.SPAWN_EGG, true, true);
                    if (playerStatueEntity == null) {
                        return ItemInteractionResult.FAIL;
                    }
                    serverLevel.addFreshEntityWithPassengers((Entity)playerStatueEntity);
                    float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(playerIn.getYRot() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                    playerStatueEntity.setGameProfile(playerBlockEntity.getPlayerProfile());
                    playerStatueEntity.moveTo(playerStatueEntity.getX(), playerStatueEntity.getY(), playerStatueEntity.getZ(), f, 0.0f);
                    PlayerStatueSpawnItem.applyRandomRotations(playerStatueEntity, level.random);
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    level.addFreshEntity((Entity)playerStatueEntity);
                    level.playSound((Player)null, playerStatueEntity.getX(), playerStatueEntity.getY(), playerStatueEntity.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                    stack.consume(1, (LivingEntity)playerIn);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)))).setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING))).setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        PlayerBlockEntity playerBlockEntity;
        super.animateTick(state, level, pos, randomSource);
        if (level.isClientSide && (playerBlockEntity = this.getBE(level, pos)) != null && playerBlockEntity.getPlayerProfile() != null && ClientHandler.TRANSLATORS.contains(playerBlockEntity.getPlayerProfile().id().orElse(null))) {
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)((double)level.random.nextFloat() - 0.5) * 3.0f + randomSource.nextFloat()) - 0.5, (double)((float)((double)level.random.nextFloat() - 0.5) * 3.0f - randomSource.nextFloat() - 1.0f), (double)((float)((double)level.random.nextFloat() - 0.5) * 3.0f + randomSource.nextFloat()) - 0.5);
        }
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

