/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.ChickenJockeyStatueBlock;
import com.shynieke.statues.blocks.statues.FloodStatueBlock;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BabyZombieStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.5, (double)9.5);

    public BabyZombieStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.isDecorative(state)) {
            StatueBlockEntity newBlockEntity;
            BlockState blockState = level.getBlockState(pos.below());
            if (blockState.is(Blocks.LAPIS_BLOCK)) {
                level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.below().getX(), (double)pos.below().getY(), (double)pos.below().getZ(), 0.0, 0.0, 0.0);
                BlockState floodState = (BlockState)((FloodStatueBlock)((Object)StatueRegistry.FLOOD_STATUE.get())).defaultBlockState().setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite());
                level.setBlockAndUpdate(pos.below(), floodState);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.VILLAGER_YES, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                newBlockEntity = new StatueBlockEntity(pos.below(), floodState);
                level.setBlockEntity((BlockEntity)newBlockEntity);
            }
            if (blockState.is((Block)StatueRegistry.CHICKEN_STATUE.get()) && this.isDecorative(blockState)) {
                level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.below().getX(), (double)pos.below().getY(), (double)pos.below().getZ(), 0.0, 0.0, 0.0);
                BlockState jockeyState = (BlockState)((ChickenJockeyStatueBlock)((Object)StatueRegistry.CHICKEN_JOCKEY_STATUE.get())).defaultBlockState().setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite());
                level.setBlockAndUpdate(pos.below(), jockeyState);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.VILLAGER_YES, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                newBlockEntity = new StatueBlockEntity(pos.below(), jockeyState);
                level.setBlockEntity((BlockEntity)newBlockEntity);
            }
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.getValue((Property)INTERACTIVE) == false;
    }

    @Override
    public boolean isBaby() {
        return true;
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.ZOMBIE;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.ZOMBIE_AMBIENT;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

