/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.Statues;
import com.shynieke.statues.menu.StatueTableMenu;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueTags;
import com.shynieke.statues.util.MultipleRecipeInput;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatueTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public int time;
    public static final int SLOT_CENTER = 0;
    public static final int SLOT_CORE = 1;
    public static final int[] SLOT_CATALYSTS = new int[]{2, 3, 4, 5};
    protected RecipeHolder<UpgradeRecipe> currentRecipe;
    private final ItemStackHandler handler = new ItemStackHandler(6){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot == 0 || slot == 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.is(StatueTags.UPGRADEABLE_STATUES);
            }
            if (slot == 1) {
                return stack.is(StatueTags.STATUE_CORE);
            }
            return super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            StatueTableBlockEntity.this.refreshClient();
        }
    };

    public StatueTableBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public StatueTableBlockEntity(BlockPos pos, BlockState state) {
        this(StatueBlockEntities.STATUE_TABLE.get(), pos, state);
    }

    protected void updateCachedRecipe() {
        if (this.level == null) {
            return;
        }
        if (this.getCenterSlot().isEmpty()) {
            this.currentRecipe = null;
            return;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStackHandler handler = this.getHandler();
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            inputs.add(i, handler.getStackInSlot(i));
        }
        this.currentRecipe = this.level.getRecipeManager().getRecipeFor(StatuesRecipes.UPGRADE_RECIPE.get(), (RecipeInput)new MultipleRecipeInput(inputs), this.level).orElse(null);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.updateCachedRecipe();
    }

    public boolean hasValidRecipe() {
        return this.currentRecipe != null;
    }

    public void executeCraft() {
        if (this.hasValidRecipe()) {
            UpgradeRecipe recipe = (UpgradeRecipe)this.currentRecipe.value();
            if (recipe.requiresCore()) {
                this.getCoreSlot().shrink(1);
            }
            ItemStackHandler handler = this.getHandler();
            for (int slot : SLOT_CATALYSTS) {
                handler.getStackInSlot(slot).shrink(1);
            }
            ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy();
            ItemStack centerStack = this.getCenterSlot();
            if (resultStack.isEmpty()) {
                if (!recipe.getUpgradeType().apply(centerStack, recipe.getTier())) {
                    Statues.LOGGER.debug("Failed to apply upgrade {} to {}", (Object)this.currentRecipe.id(), (Object)resultStack);
                    this.currentRecipe = null;
                    return;
                }
            } else {
                centerStack.shrink(1);
                handler.setStackInSlot(0, resultStack);
            }
        }
        this.level.playSound(null, this.getBlockPos(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.updateCachedRecipe();
        this.refreshClient();
    }

    public ItemStack getCenterSlot() {
        ItemStackHandler handler = this.getHandler();
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(0);
    }

    public ItemStack getCoreSlot() {
        ItemStackHandler handler = this.getHandler();
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(1);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.handler.deserializeNBT(provider, compound.getCompound("ItemStackHandler"));
        this.updateCachedRecipe();
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("ItemStackHandler", (Tag)this.handler.serializeNBT(provider));
    }

    public ItemStackHandler getHandler(@Nullable Direction direction) {
        return this.handler;
    }

    public ItemStackHandler getHandler() {
        return this.getHandler(null);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
        BlockState state = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)(this.level != null ? this.level.registryAccess() : VanillaRegistries.createLookup()));
        return nbt;
    }

    public static void renderTick(Level level, BlockPos pos, BlockState state, StatueTableBlockEntity tableBlockEntity) {
        ++tableBlockEntity.time;
    }

    public void refreshClient() {
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        this.updateCachedRecipe();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StatueTableBlockEntity tableBlockEntity) {
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"statues.container.statue_table");
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new StatueTableMenu(id, inventory, this);
    }
}

