/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.mojang.datafixers.util.Either;
import com.shynieke.statues.Statues;
import com.shynieke.statues.blockentities.AbstractStatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.fakeplayer.StatueFakePlayer;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.util.LootHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StatueBlockEntity
extends AbstractStatueBlockEntity
implements IOwnedSpawner {
    private AABB hitbox;
    protected RecipeHolder<LootRecipe> cachedLootRecipe;

    public StatueBlockEntity(BlockPos pos, BlockState state) {
        this(StatueBlockEntities.STATUE.get(), pos, state);
    }

    public StatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StatueBlockEntity blockEntity) {
        if (((Boolean)state.getValue((Property)AbstractStatueBase.INTERACTIVE)).booleanValue() && state.getBlock() instanceof AbstractStatueBase) {
            if ((float)level.getGameTime() % level.tickRateManager().tickrate() == 0.0f) {
                blockEntity.drainPower(blockEntity.getPassiveDrain());
            }
            if (!blockEntity.isStatueInteractable()) {
                --blockEntity.interactCooldown;
                if (blockEntity.interactCooldown <= 0) {
                    blockEntity.interactCooldown = blockEntity.getInteractCooldown();
                    blockEntity.setStatueInteractable(true);
                }
            }
            if (!blockEntity.isStatueAble()) {
                --blockEntity.cooldown;
                if (blockEntity.cooldown <= 0) {
                    blockEntity.cooldown = blockEntity.getCooldown();
                    blockEntity.setStatueAble(true);
                    if (blockEntity.canAutomate() && blockEntity.canDropLoot()) {
                        blockEntity.giveItem();
                        blockEntity.setStatueInteractable(false);
                    }
                }
            } else if (!level.hasNeighborSignal(pos)) {
                if (blockEntity.isSpawner()) {
                    blockEntity.summonMob((ServerLevel)level);
                }
                if (blockEntity.isKiller()) {
                    blockEntity.killMob((ServerLevel)level);
                }
                blockEntity.setStatueAble(false);
            }
            blockEntity.setChanged();
        }
    }

    @Override
    public ItemInteractionResult interact(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        AbstractStatueBase statueBase = this.getStatue();
        if (statueBase == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.makesSounds()) {
            this.playSound(statueBase.getSound(state), pos);
        }
        if (this.isStatueInteractable()) {
            if (this.canDropLoot()) {
                this.giveItem();
            }
            this.setStatueInteractable(false);
        }
        if (this.hasSpecialInteraction()) {
            this.onSpecialInteract(level, pos, state, player, handIn, result);
        }
        return ItemInteractionResult.CONSUME;
    }

    public void onSpecialInteract(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        Vec3 hitPos = result.getLocation();
        if (state.is((Block)StatueRegistry.FLOOD_STATUE.get())) {
            this.floodBehavior(player, pos, handIn, (float)hitPos.x, (float)hitPos.y, (float)hitPos.z);
        } else if (state.is((Block)StatueRegistry.MOOSHROOM_STATUE.get()) || state.is((Block)StatueRegistry.BROWN_MOOSHROOM_STATUE.get())) {
            this.mooshroomBehavior(player, pos, handIn);
        } else if (state.is((Block)StatueRegistry.COW_STATUE.get())) {
            this.cowBehavior(player, pos, handIn);
        } else if (state.is((Block)StatueRegistry.SPIDER_STATUE.get())) {
            this.giveEffect(player, pos, (Holder<MobEffect>)MobEffects.POISON);
        }
    }

    public void giveItem() {
        if (this.level != null) {
            LootRecipe loot;
            if (!this.drainPower(this.getItemPowerUsage())) {
                return;
            }
            if (this.cachedLootRecipe != null) {
                loot = (LootRecipe)this.cachedLootRecipe.value();
            } else {
                this.cachedLootRecipe = LootHelper.getMatchingLoot(this.level, new ItemStack((ItemLike)this.getBlockState().getBlock()));
                loot = (LootRecipe)this.cachedLootRecipe.value();
            }
            if (loot == null) {
                Statues.LOGGER.error("No loot found for statue {}, please report this to the Statues issue tracker", (Object)this.getBlockState());
                return;
            }
            int looting = this.getLooting();
            RegistryAccess access = this.level.registryAccess();
            ItemStack stack1 = loot.getResultItem((HolderLookup.Provider)access).copy();
            float chance1 = loot.getChance1() + (float)looting * 0.1f;
            if (!stack1.isEmpty() && this.level.random.nextDouble() <= (double)chance1) {
                this.exportItem(stack1);
            }
            ItemStack stack2 = loot.getResultItem2((HolderLookup.Provider)access).copy();
            float chance2 = loot.getChance2() + (float)looting * 0.1f;
            if (!stack2.isEmpty() && this.level.random.nextDouble() <= (double)chance2) {
                this.exportItem(stack2);
            }
            ItemStack stack3 = loot.getResultItem3(access).copy();
            float chance3 = loot.getChance3() + (float)looting * 0.1f;
            if (!stack3.isEmpty() && this.level.random.nextDouble() <= (double)chance3) {
                this.exportItem(stack3);
            }
        }
    }

    private void exportItem(ItemStack stack) {
        if (this.level.isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        if (this.canAutomate()) {
            ArrayList<AbstractStatueBlockEntity.BiggestInventory> inventoryList = new ArrayList<AbstractStatueBlockEntity.BiggestInventory>();
            for (Direction dir : Direction.values()) {
                IItemHandler itemHandler;
                BlockEntity foundTile;
                BlockPos offPos = this.worldPosition.relative(dir);
                if (!this.level.isAreaLoaded(this.worldPosition, 1) || (foundTile = this.level.getBlockEntity(offPos)) == null) continue;
                ResourceLocation typeLocation = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)foundTile.getType());
                boolean flag2 = typeLocation != null;
                IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offPos, null);
                if (!flag2 || foundTile.isRemoved() || !foundTile.hasLevel() || handler == null || (itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offPos, (Object)dir.getOpposite())) == null) continue;
                inventoryList.add(new AbstractStatueBlockEntity.BiggestInventory(offPos, itemHandler.getSlots(), dir.getOpposite()));
            }
            inventoryList.sort(Collections.reverseOrder());
            if (inventoryList.isEmpty()) {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ(), stack));
            } else {
                AbstractStatueBlockEntity.BiggestInventory inventory;
                IItemHandler itemHandler;
                ItemStack rest;
                Iterator iterator = inventoryList.iterator();
                while (iterator.hasNext() && !(rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (AbstractStatueBlockEntity.BiggestInventory)iterator.next()).getIItemHandler(serverLevel)), (ItemStack)stack, (boolean)false)).isEmpty()) {
                }
            }
        } else {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ(), stack));
        }
    }

    public void killMob(ServerLevel serverLevel) {
        BlockPos pos = this.getBlockPos();
        if (this.hitbox == null) {
            this.hitbox = new AABB((double)((float)pos.getX() - 0.5f), (double)((float)pos.getY() - 0.5f), (double)((float)pos.getZ() - 0.5f), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)).inflate(-12.0, -12.0, -12.0).inflate(12.0, 12.0, 12.0);
        }
        List<LivingEntity> targetList = this.level.getEntitiesOfClass(LivingEntity.class, this.hitbox).stream().filter(entity -> entity.getType().equals(this.getStatue().getEntity()) && !(entity instanceof FakePlayer)).toList();
        int killerLevel = this.getUpgradeLevel("mob_killer");
        for (LivingEntity target : targetList) {
            if (killerLevel > 1) {
                ItemStack tempSword = new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1);
                StatueFakePlayer.useFakePlayer(serverLevel, fakePlayer -> {
                    fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, tempSword);
                    if (!this.drainPower(this.getKillPowerUsage())) {
                        return false;
                    }
                    target.hurt(serverLevel.damageSources().playerAttack((Player)fakePlayer), (float)fakePlayer.getAttributeValue(Attributes.ATTACK_DAMAGE));
                    return true;
                });
                continue;
            }
            target.hurt(serverLevel.damageSources().generic(), 6.0f);
        }
    }

    public void summonMob(ServerLevel serverLevel) {
        BlockPos pos = this.getBlockPos();
        int spawnerLevel = this.getSpawnerLevel() + 1;
        boolean screwTheRulesIHasMoney = spawnerLevel > 3;
        int spawnCount = serverLevel.random.nextInt(spawnerLevel) + 1;
        EntityType<?> entityType = this.getStatue().getEntity();
        for (int i = 0; i < spawnCount; ++i) {
            BlockPos blockpos;
            double d2;
            double d1;
            double d0 = (double)pos.getX() + (serverLevel.random.nextDouble() - serverLevel.random.nextDouble()) * 4.0 + 0.5;
            if (!serverLevel.noCollision(entityType.getSpawnAABB(d0, d1 = (double)(pos.getY() + serverLevel.random.nextInt(3) - 1), d2 = (double)pos.getZ() + (serverLevel.random.nextDouble() - serverLevel.random.nextDouble()) * 4.0 + 0.5)) || !serverLevel.isAreaLoaded(blockpos = BlockPos.containing((double)d0, (double)d1, (double)d2), 1) || !screwTheRulesIHasMoney && !SpawnPlacements.checkSpawnRules(entityType, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)serverLevel.getRandom())) continue;
            if (!this.drainPower(this.getSummonPowerUsage())) {
                return;
            }
            Entity entity = entityType.create(this.level);
            if (entity == null) continue;
            entity.moveTo(d0, d1, d2, entity.getYRot(), entity.getXRot());
            int k = serverLevel.getEntitiesOfClass(entity.getClass(), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate(4.0)).size();
            if (k >= 6 + spawnerLevel) continue;
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (!screwTheRulesIHasMoney && !mob.checkSpawnRules((LevelAccessor)serverLevel, MobSpawnType.SPAWNER) || !mob.checkSpawnObstruction((LevelReader)serverLevel)) continue;
                EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)true);
            }
            if (!serverLevel.tryAddFreshEntityWithPassengers(entity)) continue;
            serverLevel.levelEvent(2004, pos, 0);
            serverLevel.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, blockpos);
            if (!(entity instanceof Mob)) continue;
            ((Mob)entity).spawnAnim();
        }
    }

    public void floodBehavior(Player playerIn, BlockPos pos, InteractionHand hand, float hitX, float hitY, float hitZ) {
        if (this.hasSpecialInteraction() && this.level != null && !this.level.isClientSide) {
            ItemStack stack = playerIn.getItemInHand(hand);
            int random = this.level.random.nextInt(100);
            if (stack.getItem() == Items.BUCKET && !playerIn.hasInfiniteMaterials()) {
                this.level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                stack.shrink(1);
                ItemStack floodBucket = LootHelper.getFloodBucket();
                if (stack.isEmpty()) {
                    playerIn.setItemInHand(hand, floodBucket);
                } else if (!playerIn.getInventory().add(floodBucket)) {
                    playerIn.drop(floodBucket, false);
                }
            }
            if (random < 50) {
                FireworkRocketEntity firework = new FireworkRocketEntity(this.level, (double)((float)pos.getX() + hitX), (double)((float)pos.getY() + hitY), (double)((float)pos.getZ() + hitZ), this.getFirework(this.level.random));
                this.level.addFreshEntity((Entity)firework);
            }
        }
    }

    public void mooshroomBehavior(Player playerIn, BlockPos pos, InteractionHand hand) {
        ItemStack stack;
        if (this.hasSpecialInteraction() && this.level != null && !this.level.isClientSide && (stack = playerIn.getItemInHand(hand)).getItem() == Items.BOWL && !playerIn.hasInfiniteMaterials()) {
            this.level.playSound(null, pos, SoundEvents.COW_MILK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.shrink(1);
            ItemStack soupStack = new ItemStack((ItemLike)StatueRegistry.SOUP.get());
            if (stack.isEmpty()) {
                playerIn.setItemInHand(hand, soupStack);
            } else if (!playerIn.getInventory().add(soupStack)) {
                playerIn.drop(soupStack, false);
            }
        }
    }

    public void cowBehavior(Player playerIn, BlockPos pos, InteractionHand hand) {
        ItemStack stack;
        if (this.hasSpecialInteraction() && this.level != null && !this.level.isClientSide && (stack = playerIn.getItemInHand(hand)).getItem() == Items.BUCKET && !playerIn.hasInfiniteMaterials()) {
            this.level.playSound(null, pos, SoundEvents.COW_MILK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.shrink(1);
            if (stack.isEmpty()) {
                playerIn.setItemInHand(hand, new ItemStack((ItemLike)Items.MILK_BUCKET));
            } else if (!playerIn.getInventory().add(new ItemStack((ItemLike)Items.MILK_BUCKET))) {
                playerIn.drop(new ItemStack((ItemLike)Items.MILK_BUCKET), false);
            }
        }
    }

    public void giveEffect(Player player, BlockPos pos, Holder<MobEffect> effectHolder) {
        if (this.hasSpecialInteraction() && this.level != null && !this.level.isClientSide && this.level.random.nextDouble() <= (double)0.1f && player.getEffect(effectHolder) == null) {
            player.addEffect(new MobEffectInstance(effectHolder, 400, 1, true, true));
        }
    }

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        if (this.isSpawner()) {
            return Either.left((Object)((Object)this));
        }
        return null;
    }
}

