/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.menu.ShulkerStatueMenu;
import com.shynieke.statues.registry.StatueBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerStatueBlockEntity
extends StatueBlockEntity
implements MenuProvider {
    private final ItemStackHandler handler = new ItemStackHandler(18){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack) && !(Block.byItem((Item)stack.getItem()) instanceof ShulkerBoxBlock) && !(Block.byItem((Item)stack.getItem()) instanceof ShulkerBoxBlock) && stack.getItem().canFitInsideContainerItems();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ShulkerStatueBlockEntity.this.refreshClient();
        }
    };

    public ShulkerStatueBlockEntity(BlockPos pos, BlockState state) {
        super(StatueBlockEntities.SHULKER_STATUE.get(), pos, state);
    }

    @Override
    public void onSpecialInteract(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        if (!level.isClientSide && !player.isCrouching()) {
            player.openMenu((MenuProvider)this, pos);
        }
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.handler.deserializeNBT(provider, compound.getCompound("ItemStackHandler"));
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("ItemStackHandler", (Tag)this.handler.serializeNBT(provider));
    }

    public ItemStackHandler getHandler(@Nullable Direction direction) {
        if (this.hasSpecialInteraction()) {
            return this.handler;
        }
        return null;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"statues.container.shulker_statue");
    }

    public boolean stillValid(Player player) {
        if (!this.hasSpecialInteraction()) {
            return false;
        }
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ShulkerStatueMenu(id, inventory, this);
    }

    @Override
    public void refreshClient() {
        super.refreshClient();
    }
}

