/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.ConfigManager;
import appeng.util.SettingsFrom;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemFilters;
import com.glodblock.github.extendedae.api.IRecipeMachine;
import com.glodblock.github.extendedae.api.caps.IGenericInvHost;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipe;
import com.glodblock.github.extendedae.util.FCUtil;
import com.glodblock.github.extendedae.util.RecipeExecutor;
import com.glodblock.github.glodium.recipe.CommonRecipeContext;
import com.glodblock.github.glodium.recipe.RecipeSearchContext;
import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TileCrystalAssembler
extends AENetworkedPoweredBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject,
IGenericInvHost,
IRecipeMachine<RecipeInput, CrystalAssemblerRecipe> {
    public static final int SLOTS = 9;
    public static final int TANK_CAP = 16000;
    public static final int POWER_MAXIMUM_AMOUNT = 8000;
    public static final int MAX_PROGRESS = 200;
    private final AppEngInternalInventory input = new AppEngInternalInventory((InternalInventoryHost)this, 9, 64);
    private final AppEngInternalInventory output = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final CombinedInternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.input, this.output});
    private final FilteredInternalInventory outputExposed = new FilteredInternalInventory((InternalInventory)this.output, AEItemFilters.EXTRACT_ONLY);
    private final FilteredInternalInventory inputExposed = new FilteredInternalInventory((InternalInventory)this.input, AEItemFilters.INSERT_ONLY);
    private final CombinedInternalInventory invExposed = new CombinedInternalInventory(new InternalInventory[]{this.inputExposed, this.outputExposed});
    private final IUpgradeInventory upgrades;
    private final ConfigManager configManager;
    private final GenericStackInv tank = new GenericStackInv(Set.of(AEKeyType.fluids()), this::onChangeTank, GenericStackInv.Mode.STORAGE, 1);
    private final CommonRecipeContext<CrystalAssemblerRecipe> ctx = new CrystalRecipeContext(this);
    private final RecipeExecutor<CrystalAssemblerRecipe> exec;
    private boolean isWorking = false;
    private int progress = 0;
    private final Set<Direction> outputSides = EnumSet.noneOf(Direction.class);

    public TileCrystalAssembler(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCrystalAssembler.class, TileCrystalAssembler::new, (Block)EAESingletons.CRYSTAL_ASSEMBLER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(8000.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EAESingletons.CRYSTAL_ASSEMBLER, (int)4, () -> ((TileCrystalAssembler)this).saveChanges());
        this.configManager = new ConfigManager(this::onConfigChanged);
        this.configManager.registerSetting(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.tank.setCapacity(AEKeyType.fluids(), 16000L);
        this.exec = new RecipeExecutor<CrystalAssemblerRecipe>(this, r -> r.output, 200);
    }

    protected InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.invExposed;
    }

    public IItemHandler getExposedItemHandler(@Nullable Direction side) {
        return this.invExposed.toItemHandler();
    }

    private void onConfigChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.AUTO_EXPORT) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void addProgress(int delta) {
        this.progress += delta;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public RecipeSearchContext<RecipeInput, CrystalAssemblerRecipe> getContext() {
        return this.ctx;
    }

    @Override
    public void setWorking(boolean work) {
        boolean oldVal = this.isWorking;
        this.isWorking = work;
        if (oldVal != work) {
            this.markForUpdate();
        }
    }

    public AppEngInternalInventory getInput() {
        return this.input;
    }

    public GenericStackInv getTank() {
        return this.tank;
    }

    public AppEngInternalInventory getOutput() {
        return this.output;
    }

    @Override
    public Set<Direction> getOutputSides() {
        return this.outputSides;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.TOP)));
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        boolean newWork = data.readBoolean();
        if (newWork != this.isWorking) {
            this.isWorking = newWork;
            changed = true;
        }
        return changed;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking);
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
        GenericStack fluid = this.tank.getStack(0);
        if (fluid != null) {
            fluid.what().addDrops(fluid.amount(), drops, level, pos);
        }
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.tank.writeToChildTag(data, "tank_in", registries);
        this.upgrades.writeToNBT(data, "upgrades", registries);
        this.configManager.writeToNBT(data, registries);
        this.ctx.save(data);
        ListTag sides = new ListTag();
        for (Direction side : this.getOutputSides()) {
            sides.add((Object)StringTag.valueOf((String)side.getName()));
        }
        data.put("output_side", (Tag)sides);
    }

    public void clearContent() {
        super.clearContent();
        this.tank.clear();
        this.upgrades.clear();
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        CompoundTag nbt = (CompoundTag)input.get(EAESingletons.EXTRA_SETTING);
        if (nbt != null) {
            this.outputSides.clear();
            for (Tag side : nbt.getList("output_side", 8)) {
                this.outputSides.add(Direction.byName((String)side.getAsString()));
            }
        }
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            CompoundTag nbt = new CompoundTag();
            ListTag sides = new ListTag();
            for (Direction side : this.getOutputSides()) {
                sides.add((Object)StringTag.valueOf((String)side.getName()));
            }
            nbt.put("output_side", (Tag)sides);
            output.set(EAESingletons.EXTRA_SETTING, (Object)nbt);
        }
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.tank.readFromChildTag(data, "tank_in", registries);
        this.upgrades.readFromNBT(data, "upgrades", registries);
        this.configManager.readFromNBT(data, registries);
        this.ctx.load(data);
        this.outputSides.clear();
        if (data.contains("output_side")) {
            ListTag list = data.getList("output_side", 8);
            for (Tag name : list) {
                this.outputSides.add(Direction.byName((String)name.getAsString()));
            }
        } else {
            this.outputSides.addAll(List.of(Direction.values()));
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private boolean hasAutoExportWork() {
        return !this.output.getStackInSlot(0).isEmpty() && this.configManager.getSetting(Settings.AUTO_EXPORT) == YesNo.YES;
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, !this.ctx.shouldTick() && !this.hasAutoExportWork());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        return this.exec.execute(FCUtil.speedCardMap(this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)), true);
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        return FCUtil.ejectInv(this.level, this.getBlockPos(), (InternalInventory)this.output, this.outputSides, te -> te instanceof TileCrystalAssembler);
    }

    @Override
    public IManagedGridNode getNode() {
        return this.getMainNode();
    }

    @Override
    public IEnergySource getEnergy() {
        return this;
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.saveChanges();
        this.ctx.onInvChange();
    }

    public void onChangeTank() {
        this.saveChanges();
        this.ctx.onInvChange();
    }

    @Override
    public GenericStackInv getGenericInv() {
        return this.tank;
    }

    private static class CrystalRecipeContext
    extends CommonRecipeContext<CrystalAssemblerRecipe> {
        private final TileCrystalAssembler host;

        protected CrystalRecipeContext(TileCrystalAssembler host) {
            super(() -> host.level, CrystalAssemblerRecipe.TYPE);
            this.host = host;
        }

        public void onInvChange() {
            super.onInvChange();
            this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }

        public void onFind(@Nullable RecipeHolder<CrystalAssemblerRecipe> recipe) {
            super.onFind(recipe);
            this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }

        public boolean testRecipe(RecipeHolder<CrystalAssemblerRecipe> recipe) {
            ItemStack output = ((CrystalAssemblerRecipe)recipe.value()).output.copy();
            if (!this.host.output.insertItem(0, output, true).isEmpty()) {
                return false;
            }
            List<IngredientStack<?, ?>> sample = ((CrystalAssemblerRecipe)recipe.value()).getSample();
            List<Object> copyInv = this.copyHostInv();
            for (IngredientStack<?, ?> tester : sample) {
                for (Object stack : copyInv) {
                    if (tester.checkType(stack)) {
                        tester.consume(stack);
                    }
                    if (!tester.isEmpty()) continue;
                    break;
                }
                if (!tester.isEmpty()) {
                    return false;
                }
                copyInv = copyInv.stream().filter(o -> {
                    if (o instanceof ItemStack) {
                        ItemStack s = (ItemStack)o;
                        return !s.isEmpty();
                    }
                    if (o instanceof FluidStack) {
                        FluidStack f = (FluidStack)o;
                        return !f.isEmpty();
                    }
                    return false;
                }).toList();
            }
            return true;
        }

        public void runRecipe(RecipeHolder<CrystalAssemblerRecipe> recipe) {
            AEKey aEKey;
            List<IngredientStack<?, ?>> sample = ((CrystalAssemblerRecipe)recipe.value()).getSample();
            GenericStack fluid = this.host.tank.getStack(0);
            FluidStack fluidStack = null;
            if (fluid != null && (aEKey = fluid.what()) instanceof AEFluidKey) {
                AEFluidKey key = (AEFluidKey)aEKey;
                fluidStack = key.toStack((int)fluid.amount());
            }
            for (IngredientStack<?, ?> tester : sample) {
                for (int x = 0; x < this.host.input.size(); ++x) {
                    ItemStack item = this.host.input.getStackInSlot(x);
                    if (tester.checkType((Object)item)) {
                        tester.consume((Object)item);
                        this.host.input.setItemDirect(x, item);
                    }
                    if (tester.isEmpty()) break;
                }
                if (fluidStack == null || tester.isEmpty() || !tester.checkType((Object)fluidStack)) continue;
                tester.consume((Object)fluidStack);
            }
            if (fluidStack != null) {
                if (fluidStack.isEmpty()) {
                    this.host.tank.setStack(0, null);
                } else {
                    this.host.tank.setStack(0, new GenericStack((AEKey)AEFluidKey.of((FluidStack)fluidStack), (long)fluidStack.getAmount()));
                }
            }
        }

        public List<Object> copyHostInv() {
            AEKey aEKey;
            ArrayList<Object> inv = new ArrayList<Object>();
            for (ItemStack item : this.host.input) {
                if (item.isEmpty()) continue;
                inv.add(item.copy());
            }
            GenericStack fluid = this.host.tank.getStack(0);
            if (fluid != null && (aEKey = fluid.what()) instanceof AEFluidKey) {
                AEFluidKey key = (AEFluidKey)aEKey;
                inv.add(key.toStack((int)fluid.amount()));
            }
            return inv;
        }
    }
}

