/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.hotkey;

import appeng.crafting.pattern.EncodedPatternItem;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CPatternKey;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;

public class PatternHotKey {
    private static final KeyMapping VIEW_PATTERN = new KeyMapping("key.extendedae.viewpattern", 80, "key.extendedae.category");

    public static void onInit() {
        NeoForge.EVENT_BUS.addListener(evt -> PatternHotKey.hookTooltip(evt.getItemStack(), evt.getToolTip()));
    }

    private static void hookTooltip(ItemStack stack, List<Component> tooltip) {
        if (PatternHotKey.isKeyBound() && stack.getItem() instanceof EncodedPatternItem) {
            tooltip.add(1, (Component)Component.translatable((String)"pattern.tooltip", (Object[])new Object[]{VIEW_PATTERN.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
            if (PatternHotKey.pressed()) {
                EAENetworkHandler.INSTANCE.sendToServer(new CPatternKey(stack));
            }
        }
    }

    private static boolean pressed() {
        int keyCode = VIEW_PATTERN.getKey().getValue();
        long window = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)window, (int)keyCode);
    }

    private static boolean isKeyBound() {
        return !VIEW_PATTERN.isUnbound();
    }

    public static KeyMapping getHotKey() {
        return VIEW_PATTERN;
    }

    static {
        VIEW_PATTERN.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.GUI);
    }
}

