/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.common.blocks.prism.AccelerationPrismLens;
import alexthw.ars_elemental.common.blocks.prism.ArcPrismLens;
import alexthw.ars_elemental.common.blocks.prism.DecelerationPrismLens;
import alexthw.ars_elemental.common.blocks.prism.HomingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.PiercingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.RainbowPrismLens;
import alexthw.ars_elemental.common.glyphs.MethodArcProjectile;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.common.items.NecroEssence;
import alexthw.ars_elemental.common.items.foci.ElementalFocus;
import alexthw.ars_elemental.datagen.Datagen;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.RecipeDatagen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class AEImbuementProvider
extends ImbuementRecipeProvider {
    public AEImbuementProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
        this.collectJsons(pOutput);
        ArrayList futures = new ArrayList();
        return Datagen.provider.thenCompose(registry -> {
            for (ImbuementRecipe g : this.recipes) {
                Path path = this.getRecipePath(this.output, g.id.getPath());
                futures.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        });
    }

    public void collectJsons(CachedOutput cache) {
        this.recipes.add(new ImbuementRecipe("imbuement_anima_essence", RecipeDatagen.SOURCE_GEM, ((NecroEssence)((Object)ModItems.ANIMA_ESSENCE.get())).getDefaultInstance(), 3000).withPedestalItem((ItemLike)Items.WITHER_SKELETON_SKULL).withPedestalItem((ItemLike)Items.BONE_MEAL).withPedestalItem((ItemLike)Items.GOLDEN_APPLE));
        this.recipes.add(new ImbuementRecipe("lesser_fire_focus", Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), ((ElementalFocus)ModItems.LESSER_FIRE_FOCUS.get()).getDefaultInstance(), 5000).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT));
        this.recipes.add(new ImbuementRecipe("lesser_water_focus", Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), ((ElementalFocus)ModItems.LESSER_WATER_FOCUS.get()).getDefaultInstance(), 5000).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT));
        this.recipes.add(new ImbuementRecipe("lesser_earth_focus", Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), ((ElementalFocus)ModItems.LESSER_EARTH_FOCUS.get()).getDefaultInstance(), 5000).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT));
        this.recipes.add(new ImbuementRecipe("lesser_air_focus", Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), ((ElementalFocus)ModItems.LESSER_AIR_FOCUS.get()).getDefaultInstance(), 5000).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT));
        this.recipes.add(new ImbuementRecipe("fire_turret", Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ENCHANTED_SPELL_TURRET}), new ItemStack((ItemLike)ModItems.FIRE_TURRET.get(), 1), 5000).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ModItems.FIRE_FOCUS.get()));
        this.recipes.add(new ImbuementRecipe("water_turret", Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ENCHANTED_SPELL_TURRET}), new ItemStack((ItemLike)ModItems.WATER_TURRET.get(), 1), 5000).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ModItems.WATER_FOCUS.get()));
        this.recipes.add(new ImbuementRecipe("air_turret", Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ENCHANTED_SPELL_TURRET}), new ItemStack((ItemLike)ModItems.AIR_TURRET.get(), 1), 5000).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ModItems.AIR_FOCUS.get()));
        this.recipes.add(new ImbuementRecipe("earth_turret", Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ENCHANTED_SPELL_TURRET}), new ItemStack((ItemLike)ModItems.EARTH_TURRET.get(), 1), 5000).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ModItems.EARTH_FOCUS.get()));
        this.recipes.add(new ImbuementRecipe("manipulation_turret", Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ENCHANTED_SPELL_TURRET}), new ItemStack((ItemLike)ModItems.SHAPING_TURRET.get(), 1), 5000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.SHAPERS_FOCUS.get()));
        this.recipes.add(new ImbuementRecipe("mark_of_mastery", Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_TRIBUTE}), new ItemStack((ItemLike)ModItems.MARK_OF_MASTERY.get(), 5), 10000).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ModItems.ANIMA_ESSENCE.get()));
        this.recipes.add(new ImbuementRecipe("arc_prism_lens", Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), ((ArcPrismLens)ModItems.ARC_LENS.get()).getDefaultInstance(), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)MethodArcProjectile.INSTANCE.getGlyph()));
        this.recipes.add(new ImbuementRecipe("homing_prism_lens", Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), ((HomingPrismLens)ModItems.HOMING_LENS.get()).getDefaultInstance(), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)MethodHomingProjectile.INSTANCE.getGlyph()));
        this.recipes.add(new ImbuementRecipe("acceleration_prism_lens", Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), ((AccelerationPrismLens)ModItems.ACC_LENS.get()).getDefaultInstance(), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)AugmentAccelerate.INSTANCE.getGlyph()));
        this.recipes.add(new ImbuementRecipe("deceleration_prism_lens", Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), ((DecelerationPrismLens)ModItems.DEC_LENS.get()).getDefaultInstance(), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)AugmentDecelerate.INSTANCE.getGlyph()));
        this.recipes.add(new ImbuementRecipe("piercing_prism_lens", Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), ((PiercingPrismLens)ModItems.PIERCE_LENS.get()).getDefaultInstance(), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)AugmentPierce.INSTANCE.getGlyph()));
        this.recipes.add(new ImbuementRecipe("rainbow_prism_lens", Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), ((RainbowPrismLens)ModItems.RGB_LENS.get()).getDefaultInstance(), 2000).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.DYES)));
    }

    protected Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_elemental/recipe/" + str + ".json");
    }

    @NotNull
    public String getName() {
        return "Ars Elemental Imbuement";
    }
}

