/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.blocks.ElementalTurret;
import alexthw.ars_elemental.common.blocks.SporeBlossomGround;
import alexthw.ars_elemental.datagen.Datagen;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import java.util.HashSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class AEBlockStateProvider
extends BlockStateProvider {
    public AEBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "ars_elemental", exFileHelper);
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(ModItems.BLOCKS.getEntries());
        Datagen.takeAll(blocks, b -> b.get() instanceof FlowerPotBlock).forEach(this::registerOnlyState);
        Datagen.takeAll(blocks, b -> b.get() instanceof TickableModBlock || b.get() instanceof ElementalTurret || b.get() instanceof SpellPrismBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock || b.get() instanceof StrippableLog).forEach(this::logBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(this::slabBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof StairBlock).forEach(this::stairsBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof SaplingBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof ArchfruitPod);
        Datagen.takeAll(blocks, b -> b.get() instanceof SporeBlossomGround);
        Datagen.takeAll(blocks, b -> b.get() instanceof FlowerBlock).forEach(this::registerOnlyState);
        blocks.forEach(this::basicBlock);
    }

    public void registerOnlyState(DeferredHolder<Block, ? extends Block> obj) {
        this.simpleBlock((Block)obj.get(), (ModelFile)new ModelFile.UncheckedModelFile(ArsElemental.prefix("block/" + obj.getId().getPath())));
    }

    public void slabBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().getPath();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), ArsElemental.prefix(baseName), ArsElemental.prefix("block/" + baseName));
    }

    public void logBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
    }

    public void stairsBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().getPath();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairBlock)blockRegistryObject.get(), ArsElemental.prefix("block/" + baseName));
    }

    public void basicBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    @NotNull
    public String getName() {
        return "Ars Elemental BlockStates";
    }
}

