/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancementBuilder;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancements;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class AEAdvancementsProvider
extends AdvancementProvider {
    public AEAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new AEAdvancements()));
    }

    public String getOldName() {
        return "Ars Elemental Advancement Datagen";
    }

    public static class AEAdvancements
    extends ANAdvancements {
        static Consumer<AdvancementHolder> advancementConsumer;

        static AdvancementHolder dummy(String name) {
            return new AdvancementHolder(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)name), null);
        }

        public void generate(HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> con, @NotNull ExistingFileHelper existingFileHelper) {
            advancementConsumer = con;
            this.saveBasicItem((ItemLike)ModItems.SIREN_CHARM.get(), AEAdvancements.dummy("poof_mob"));
            this.saveBasicItem((ItemLike)ModItems.FIRENANDO_CHARM.get(), AEAdvancements.dummy("enchanting_apparatus"));
            this.saveBasicItem((ItemLike)ModItems.MARK_OF_MASTERY.get(), AEAdvancements.dummy("wilden_tribute"));
            this.saveBasicItem((ItemLike)ModItems.WATER_URN.get(), AEAdvancements.dummy("enchanting_apparatus"));
            this.builder("mirror_shield").display((ItemLike)ItemsRegistry.ENCHANTERS_SHIELD, AdvancementType.CHALLENGE, true).addCriterion(((PlayerTrigger)ModAdvTriggers.MIRROR.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).parent(AEAdvancements.dummy("enchanting_apparatus")).save(con);
            AdvancementHolder curioBag = this.saveBasicItem((ItemLike)ModItems.CURIO_BAG.get(), AEAdvancements.dummy("magebloom_crop"));
            this.saveBasicItem((ItemLike)ModItems.CASTER_BAG.get(), curioBag);
            AdvancementHolder air = this.saveBasicItem((ItemLike)ModItems.LESSER_AIR_FOCUS.get(), curioBag);
            AdvancementHolder fire = this.saveBasicItem((ItemLike)ModItems.LESSER_FIRE_FOCUS.get(), curioBag);
            AdvancementHolder earth = this.saveBasicItem((ItemLike)ModItems.LESSER_EARTH_FOCUS.get(), curioBag);
            AdvancementHolder water = this.saveBasicItem((ItemLike)ModItems.LESSER_WATER_FOCUS.get(), curioBag);
            this.buildBasicItem((ItemLike)ModItems.AIR_FOCUS.get(), "air_focus", AdvancementType.CHALLENGE, air).save(con);
            this.buildBasicItem((ItemLike)ModItems.FIRE_FOCUS.get(), "fire_focus", AdvancementType.CHALLENGE, fire).save(con);
            this.buildBasicItem((ItemLike)ModItems.EARTH_FOCUS.get(), "earth_focus", AdvancementType.CHALLENGE, earth).save(con);
            this.buildBasicItem((ItemLike)ModItems.WATER_FOCUS.get(), "water_focus", AdvancementType.CHALLENGE, water).save(con);
            AdvancementHolder necro = this.saveBasicItem((ItemLike)ModItems.NECRO_FOCUS.get(), AEAdvancements.dummy("summon_focus"));
            this.builder("summon_skeleton_horse").display((ItemLike)ModItems.NECRO_CTOME.get(), AdvancementType.GOAL).addCriterion(SummonedEntityTrigger.TriggerInstance.summonedEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)ModEntities.SKELEHORSE_SUMMON.get()))).parent(necro).save(con);
            this.builder("summon_strider").display((ItemLike)ModItems.FIRE_CTOME.get(), AdvancementType.GOAL).addCriterion(SummonedEntityTrigger.TriggerInstance.summonedEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)ModEntities.STRIDER_SUMMON.get()))).parent(fire).save(con);
            this.builder("summon_dolphin").display((ItemLike)ModItems.WATER_CTOME.get(), AdvancementType.GOAL).addCriterion(SummonedEntityTrigger.TriggerInstance.summonedEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)ModEntities.DOLPHIN_SUMMON.get()))).parent(water).save(con);
            this.builder("levitation").display((ItemLike)ModItems.AIR_CTOME.get(), AdvancementType.GOAL).addCriterion(((PlayerTrigger)ModAdvTriggers.LEVITATE.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).parent(air).save(con);
            this.builder("spore_blossom").display((ItemLike)ModItems.GROUND_BLOSSOM.get(), AdvancementType.GOAL).addCriterion(((PlayerTrigger)ModAdvTriggers.BLOSSOM.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).parent(earth).save(con);
        }

        public AdvancementHolder saveBasicItem(ItemLike item, AdvancementHolder parent) {
            return this.buildBasicItem(item, BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath(), AdvancementType.TASK, parent).save(advancementConsumer);
        }

        public ANAdvancementBuilder buildBasicItem(ItemLike item, String id, AdvancementType frame, AdvancementHolder parent) {
            return this.builder(id).display(item, frame).requireItem(item).parent(parent);
        }

        public ANAdvancementBuilder builder(String key) {
            return ANAdvancementBuilder.builder((String)"ars_elemental", (String)key);
        }
    }
}

