/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spikes;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class EnchantedDripstoneEntity
extends EnchantedFallingBlock {
    boolean icy;

    public EnchantedDripstoneEntity(EntityType<? extends ColoredProjectile> entityType, Level level, boolean ice) {
        super(entityType, level);
        this.dropItem = false;
        this.icy = ice;
    }

    public EnchantedDripstoneEntity(Level world, BlockPos pos, SpellResolver resolver, SpellStats spellStats) {
        super(world, pos, (BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)Direction.DOWN), resolver);
        this.dropItem = false;
        this.context = resolver.spellContext;
        this.spellStats = spellStats;
        this.icy = ISchoolFocus.waterCheck(resolver);
        this.setXRot(0.0f);
        this.setYRot(0.0f);
    }

    public EnchantedDripstoneEntity(EntityType<EnchantedDripstoneEntity> enchantedDripstoneEntityEntityType, Level level) {
        this(enchantedDripstoneEntityEntityType, level, false);
    }

    @NotNull
    public EntityType<?> getType() {
        return this.icy ? (EntityType)ModEntities.THROWN_ICE_SPIKE.get() : (EntityType)ModEntities.THROWN_SPIKE.get();
    }
}

