/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client.firenando;

import alexthw.ars_elemental.client.firenando.FirenandoModel;
import alexthw.ars_elemental.common.entity.FirenandoEntity;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FirenandoRenderer<M extends LivingEntity>
extends GeoEntityRenderer<M> {
    ParticleColor color1 = new ParticleColor(230, 45, 15);
    ParticleColor color2 = new ParticleColor(15, 100, 200);
    ParticleColor sideColor = new ParticleColor(150, 200, 15);

    public FirenandoRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new FirenandoModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull M instance) {
        ResourceLocation resourceLocation;
        if (instance instanceof FirenandoEntity) {
            FirenandoEntity var = (FirenandoEntity)instance;
            resourceLocation = var.getTexture();
        } else {
            resourceLocation = super.getTextureLocation(instance);
        }
        return resourceLocation;
    }

    public RenderType getRenderType(M animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public void render(@NotNull M entity, float entityYaw, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        FirenandoEntity fe;
        super.render(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        if (entity instanceof FirenandoEntity && (fe = (FirenandoEntity)entity).isActive()) {
            ParticleColor color = fe.getColor().equals("soul") ? this.color2 : this.color1;
            entity.level().addParticle(GlowParticleData.createData((ParticleColor)color, (boolean)false, (float)0.3f, (float)0.7f, (int)15), entity.getX() + ParticleUtil.inRange((double)-0.1, (double)0.1) / 4.0, entity.getY() + 0.6, entity.getZ() + ParticleUtil.inRange((double)-0.1, (double)0.1) / 4.0, 0.0, (double)-0.05f, 0.0);
            entity.level().addParticle(GlowParticleData.createData((ParticleColor)this.sideColor, (boolean)false, (float)0.15f, (float)0.7f, (int)15), entity.getX() + ParticleUtil.inRange((double)-0.1, (double)0.1) / 4.0, entity.getY() + 0.6, entity.getZ() + ParticleUtil.inRange((double)-0.1, (double)0.1) / 4.0, 0.0, (double)-0.05f, 0.0);
        }
    }
}

