/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.datagen;

import com.mrbysco.flowerpatch.Constants;
import com.mrbysco.flowerpatch.block.CompatPatchBlock;
import com.mrbysco.flowerpatch.block.FlowerPatchBlock;
import com.mrbysco.flowerpatch.block.PatchBlock;
import com.mrbysco.flowerpatch.registration.CompatRegistry;
import com.mrbysco.flowerpatch.registration.PatchRegistry;
import com.mrbysco.flowerpatch.registration.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PatchDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput, lookupProvider));
            PatchBlockTags provider = new PatchBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)provider);
            generator.addProvider(event.includeServer(), (DataProvider)new PatchItemTags(packOutput, lookupProvider, provider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(PatchBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
            super.validate(writableregistry, validationcontext, problemreporter$collector);
        }

        public static class PatchBlockLoot
        extends BlockLootSubProvider {
            protected PatchBlockLoot(HolderLookup.Provider lookupProvider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
            }

            protected void generate() {
                PatchBlock patch;
                Block block;
                for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                    block = registryObject.get();
                    if (!(block instanceof PatchBlock)) continue;
                    patch = (PatchBlock)block;
                    this.addPatch(patch);
                }
                for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                    block = registryObject.get();
                    if (!(block instanceof PatchBlock)) continue;
                    patch = (PatchBlock)block;
                    this.add(registryObject.get(), LootTable.lootTable());
                }
            }

            private void addPatch(PatchBlock patch) {
                this.add((Block)patch, block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)((ItemLike)patch.getPatchDelegate().get())).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), value -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)value.floatValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)patch.getProperty(), value.intValue()))))))));
            }

            protected Iterable<Block> getKnownBlocks() {
                ArrayList blocks = new ArrayList();
                PatchRegistry.BLOCKS.getEntries().forEach(object -> blocks.add((Block)object.get()));
                CompatRegistry.BLOCKS.getEntries().forEach(object -> blocks.add((Block)object.get()));
                return blocks::iterator;
            }
        }
    }

    public static class PatchBlockTags
    extends BlockTagsProvider {
        public PatchBlockTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "flowerpatch", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                Block block = registryObject.get();
                if (!(block instanceof FlowerPatchBlock)) continue;
                FlowerPatchBlock flowerPatchBlock = (FlowerPatchBlock)block;
                this.tag(BlockTags.FLOWERS).add((Object)flowerPatchBlock);
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof CompatPatchBlock)) continue;
                this.tag(BlockTags.FLOWERS).addOptional(registryObject.getId());
            }
            this.tag(Constants.BONEMEAL_ABLE_FLOWERS).add((Object[])new Block[]{Blocks.DANDELION, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.LILY_OF_THE_VALLEY});
        }
    }

    public static class PatchItemTags
    extends ItemTagsProvider {
        public PatchItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "flowerpatch", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(Constants.BONEMEAL).add((Object)Items.BONE_MEAL);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "flowerpatch", "en_us");
        }

        protected void addTranslations() {
            PatchBlock patchBlock;
            Block block;
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                block = registryObject.get();
                if (!(block instanceof PatchBlock)) continue;
                patchBlock = (PatchBlock)block;
                this.addBlock(registryObject, I18n.get((String)patchBlock.getPatchDelegate().get().getDescriptionId(), (Object[])new Object[0]) + " Patch");
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                block = registryObject.get();
                if (!(block instanceof PatchBlock)) continue;
                patchBlock = (PatchBlock)block;
                this.addBlock(registryObject, "%s Patch");
            }
            this.add("text.autoconfig.flowerpatch.title", "Flower Patch");
            this.add("text.autoconfig.flowerpatch.option.general", "General");
            this.add("text.autoconfig.flowerpatch.option.general.flowerToPatchBonemealing", "flowerToPatchBonemealing");
            this.add("text.autoconfig.flowerpatch.option.general.patchBonemealing", "patchBonemealing");
            this.add("text.autoconfig.flowerpatch.option.general.placeOnLeaves", "placeOnLeaves");
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "flowerpatch", helper);
        }

        protected void registerModels() {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchModels(registryObject.get());
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                Block block = registryObject.get();
                if (!(block instanceof CompatPatchBlock)) continue;
                CompatPatchBlock patchBlock = (CompatPatchBlock)block;
                this.compatCrossBlock(patchBlock);
            }
        }

        protected void generatePatchModels(Block block) {
            this.crossBlock(block);
        }

        private void crossBlock(Block block) {
            this.patchBlock(block, 2);
            this.patchBlock(block, 3);
            this.patchBlock(block, 4);
        }

        private BlockModelBuilder patchBlock(Block block, int flowers) {
            String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_" + flowers;
            return (BlockModelBuilder)((BlockModelBuilder)this.singleTexture(path, this.modLoc("block/patch" + flowers), "cross", this.mcLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)((PatchBlock)block).getPatchDelegate().get()).getPath()))).renderType("cutout");
        }

        private void compatCrossBlock(CompatPatchBlock block) {
            this.compatPatchBlock(block, 2);
            this.compatPatchBlock(block, 3);
            this.compatPatchBlock(block, 4);
        }

        private BlockModelBuilder compatPatchBlock(CompatPatchBlock block, int flowers) {
            String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_" + flowers;
            return (BlockModelBuilder)((BlockModelBuilder)this.singleTexture(path, this.modLoc("block/patch" + flowers), "cross", ResourceLocation.fromNamespaceAndPath((String)block.getNameSpace(), (String)("block/" + block.getTexturePath())))).renderType("cutout");
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "flowerpatch", helper);
        }

        protected void registerStatesAndModels() {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchState(registryObject.get());
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchState(registryObject.get());
            }
        }

        protected void generatePatchState(Block block) {
            ModelFile.ExistingModelFile patchModel2 = this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_2"));
            ModelFile.ExistingModelFile patchModel3 = this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_3"));
            ModelFile.ExistingModelFile patchModel4 = this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_4"));
            PatchBlock patchBlock = (PatchBlock)block;
            this.getVariantBuilder(block).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel2), new ConfiguredModel((ModelFile)patchModel2, 0, 90, false), new ConfiguredModel((ModelFile)patchModel2, 0, 180, false), new ConfiguredModel((ModelFile)patchModel2, 0, 270, false)}).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(3)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel3), new ConfiguredModel((ModelFile)patchModel3, 0, 90, false), new ConfiguredModel((ModelFile)patchModel3, 0, 180, false), new ConfiguredModel((ModelFile)patchModel3, 0, 270, false)}).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(4)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel4), new ConfiguredModel((ModelFile)patchModel4, 0, 90, false), new ConfiguredModel((ModelFile)patchModel4, 0, 180, false), new ConfiguredModel((ModelFile)patchModel4, 0, 270, false)});
        }
    }
}

