/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.blay09.mods.trashslot.network.MessageTrashSlotContent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MessageDeleteFromSlot
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<MessageDeleteFromSlot> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"trashslot", (String)"delete_from_slot"));
    private final int slotNumber;
    private final boolean isDeleteAll;

    public MessageDeleteFromSlot(int slotNumber, boolean isDeleteAll) {
        this.slotNumber = slotNumber;
        this.isDeleteAll = isDeleteAll;
    }

    public static void encode(FriendlyByteBuf buf, MessageDeleteFromSlot message) {
        buf.writeVarInt(message.slotNumber);
        buf.writeBoolean(message.isDeleteAll);
    }

    public static MessageDeleteFromSlot decode(FriendlyByteBuf buf) {
        int slotNumber = buf.readVarInt();
        boolean isDeleteAll = buf.readBoolean();
        return new MessageDeleteFromSlot(slotNumber, isDeleteAll);
    }

    public static void handle(ServerPlayer player, MessageDeleteFromSlot message) {
        if (player.isSpectator()) {
            return;
        }
        if (message.slotNumber == -1) {
            TrashHelper.setTrashItem((Player)player, ItemStack.EMPTY);
            Balm.getNetworking().reply((CustomPacketPayload)new MessageTrashSlotContent(ItemStack.EMPTY));
            return;
        }
        if (!player.containerMenu.getCarried().isEmpty()) {
            return;
        }
        AbstractContainerMenu container = player.containerMenu;
        Slot deleteSlot = (Slot)container.slots.get(message.slotNumber);
        if (deleteSlot instanceof ResultSlot) {
            return;
        }
        if (message.isDeleteAll) {
            ItemStack deleteStack = deleteSlot.getItem().copy();
            if (!deleteStack.isEmpty() && MessageDeleteFromSlot.attemptDeleteFromSlot((Player)player, container, message.slotNumber)) {
                ItemStack slotStack;
                for (int i = 0; i < container.slots.size() && ((slotStack = ((Slot)container.slots.get(i)).getItem()).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)deleteStack) || MessageDeleteFromSlot.attemptDeleteFromSlot((Player)player, container, i)); ++i) {
                }
            }
        } else {
            MessageDeleteFromSlot.attemptDeleteFromSlot((Player)player, container, message.slotNumber);
        }
        Balm.getNetworking().reply((CustomPacketPayload)new MessageTrashSlotContent(TrashHelper.getTrashItem((Player)player)));
    }

    private static boolean attemptDeleteFromSlot(Player player, AbstractContainerMenu container, int slotNumber) {
        ItemStack itemStack = ((Slot)container.slots.get(slotNumber)).getItem().copy();
        ResourceLocation registryName = Balm.getRegistries().getKey(itemStack.getItem());
        if (registryName != null && TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
            return false;
        }
        container.clicked(slotNumber, 0, ClickType.PICKUP, player);
        ItemStack mouseStack = container.getCarried();
        if (ItemStack.matches((ItemStack)itemStack, (ItemStack)mouseStack)) {
            container.setCarried(ItemStack.EMPTY);
            TrashHelper.setTrashItem(player, mouseStack);
            return !itemStack.isEmpty();
        }
        ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, 0, 0, mouseStack));
        return false;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

