/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankException;
import dev.ftb.mods.ftbranks.impl.FTBRanksAPIImpl;
import dev.ftb.mods.ftbranks.impl.condition.DefaultCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class FTBRanksCommands {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_RANK = new DynamicCommandExceptionType(object -> Component.literal((String)("Unknown rank: " + object.toString())));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbranks").requires(source -> source.getServer() != null && source.getServer().isSingleplayer() || source.hasPermission(2))).then(Commands.literal((String)"reload").executes(context -> FTBRanksCommands.reloadRanks((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"refresh_readme").executes(context -> FTBRanksCommands.refreshReadme((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"list_all_ranks").executes(context -> FTBRanksCommands.listAllRanks((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"create").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"power", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> FTBRanksCommands.createRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"power"))))).executes(context -> FTBRanksCommands.createRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), 1))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.deleteRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(Commands.literal((String)"add").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.addRank((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.removeRank((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.literal((String)"list_ranks_of").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> FTBRanksCommands.listRanksOf((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"list_players_with").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.listPlayersWith((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"node").then(Commands.literal((String)"add").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(Commands.argument((String)"node", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.setNode((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"node"), StringArgumentType.getString((CommandContext)context, (String)"value")))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(Commands.argument((String)"node", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.setNode((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"node"), null)))))).then(Commands.literal((String)"list").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.listNodes((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.literal((String)"condition").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.setCondition((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"value"))))))).then(Commands.literal((String)"show_rank").then(Commands.argument((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.showRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))));
    }

    private static CompletableFuture<Suggestions> suggestRanks(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(FTBRanksAPI.manager().getAllRanks().stream().map(Rank::getId), (SuggestionsBuilder)builder);
    }

    private static String normalizeRankName(String name) {
        return name.toLowerCase().replace("+", "_plus").replaceAll("[^a-z0-9_]", "_").replaceAll("_{2,}", "_");
    }

    private static int reloadRanks(CommandSourceStack source) {
        try {
            FTBRanksAPIImpl.manager.reload();
            source.sendSuccess(() -> Component.literal((String)"Ranks reloaded from disk!"), true);
            for (ServerPlayer p : source.getServer().getPlayerList().getPlayers()) {
                source.getServer().getPlayerList().sendPlayerPermissionLevel(p);
            }
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            source.sendFailure((Component)Component.literal((String)ex.getLocalizedMessage()));
            return 0;
        }
    }

    private static int refreshReadme(CommandSourceStack source) {
        try {
            FTBRanksAPIImpl.manager.refreshReadme();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        source.sendSuccess(() -> Component.literal((String)"README file refreshed!"), false);
        return 1;
    }

    private static Component makeRankNameClicky(Rank rank) {
        boolean isDef = rank.getCondition().isDefaultCondition();
        return Component.literal((String)rank.getName()).withStyle(isDef ? ChatFormatting.AQUA : ChatFormatting.YELLOW).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbranks show_rank " + rank.getId())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)(isDef ? Component.literal((String)("Players must be explicitly added to this rank\nwith '/ftbranks add <player> " + rank.getId() + "'")).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}) : Component.literal((String)("Rank condition: " + rank.getCondition().asString())).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})))));
    }

    private static int listAllRanks(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"Ranks:"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            source.sendSuccess(() -> Component.literal((String)"- ").append(FTBRanksCommands.makeRankNameClicky(rank)), false);
        }
        return 1;
    }

    private static int createRank(CommandSourceStack source, String name, int power) {
        try {
            Rank rank = FTBRanksAPI.manager().createRank(name, power, false);
            source.sendSuccess(() -> Component.literal((String)("Rank '" + rank.getId() + "' created!")), false);
            return 1;
        }
        catch (RankException e) {
            source.sendFailure((Component)Component.literal((String)("Could not create rank '" + name + "': " + e.getMessage())));
            return 0;
        }
    }

    private static int deleteRank(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        FTBRanksAPI.manager().deleteRank(rank.getId());
        source.sendSuccess(() -> Component.literal((String)("Rank '" + rank.getName() + "' deleted!")), false);
        return 1;
    }

    private static int addRank(CommandSourceStack source, Collection<GameProfile> players, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        for (GameProfile profile : players) {
            if (!rank.add(profile)) continue;
            source.sendSuccess(() -> Component.literal((String)String.format("Player %s added to rank '%s'!", profile.getName(), rank.getName())), false);
        }
        return 1;
    }

    private static int removeRank(CommandSourceStack source, Collection<GameProfile> players, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        for (GameProfile profile : players) {
            if (!rank.remove(profile)) continue;
            source.sendSuccess(() -> Component.literal((String)String.format("Player %s removed from rank '%s'!", profile.getName(), rank.getName())), false);
        }
        return 1;
    }

    private static int listRanksOf(CommandSourceStack source, ServerPlayer player) {
        source.sendSuccess(() -> Component.literal((String)String.format("Ranks added to player '%s':", player.getGameProfile().getName())), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            if (!rank.isActive(player)) continue;
            source.sendSuccess(() -> Component.literal((String)"- ").append(FTBRanksCommands.makeRankNameClicky(rank)), false);
        }
        return 1;
    }

    private static int listPlayersWith(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        source.sendSuccess(() -> Component.literal((String)String.format("Players with rank '%s':", rank.getName())), false);
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            if (!rank.isActive(player)) continue;
            source.sendSuccess(() -> Component.literal((String)"- ").withStyle(ChatFormatting.YELLOW).append(player.getDisplayName()), false);
        }
        return 1;
    }

    private static int listNodes(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        Collection<String> nodes = rank.getPermissions();
        if (nodes.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)String.format("No permission nodes in rank '%s'", rankName)).withStyle(ChatFormatting.GOLD), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)String.format("%d permission node(s) in rank '%s':", nodes.size(), rankName)).withStyle(ChatFormatting.GREEN), false);
            source.sendSuccess(() -> Component.literal((String)"-".repeat(20)).withStyle(ChatFormatting.GREEN), false);
            nodes.forEach(node -> source.sendSuccess(() -> Component.literal((String)String.format("%s = %s", node, rank.getPermission((String)node))).withStyle(ChatFormatting.YELLOW), false));
            source.sendSuccess(() -> Component.literal((String)"-".repeat(20)).withStyle(ChatFormatting.GREEN), false);
        }
        return 1;
    }

    private static int setNode(CommandSourceStack source, String rankName, String node, String value) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        try {
            rank.setPermission(node, PermissionValue.parse(value));
            if (value != null) {
                source.sendSuccess(() -> Component.literal((String)String.format("Permission node '%s'='%s' added to rank '%s'", node, rank.getPermission(node), rank)), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)String.format("Permission node '%s' removed from rank '%s'", node, rank)), false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)e.getMessage())).create();
        }
        return 1;
    }

    private static int setCondition(CommandSourceStack source, String rankName, String value) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        try {
            RankCondition condition = value.equals("default") || value.equals("\"\"") ? new DefaultCondition(rank) : (value.startsWith("{") || value.contains(" ") ? FTBRanksAPI.manager().createCondition(rank, (Tag)SNBT.readLines(Collections.singletonList(value))) : FTBRanksAPI.manager().createCondition(rank, (Tag)StringTag.valueOf((String)value)));
            rank.setCondition(condition);
            source.sendSuccess(() -> Component.literal((String)String.format("Condition '%s' added to rank '%s'", value, rank)), false);
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)e.getMessage())).create();
        }
        return 1;
    }

    private static int showRank(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        source.sendSuccess(() -> Component.literal((String)"=".repeat(50)).withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.literal((String)"Rank ID: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)rank.getId()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)", Rank Name: ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)rank.getName()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)", Power: ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)String.valueOf(rank.getPower())).withStyle(ChatFormatting.WHITE)), true);
        String condStr = rank.getCondition().asString();
        MutableComponent c = condStr.isEmpty() ? Component.literal((String)"(none: players must be added)").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}) : Component.literal((String)condStr).withStyle(ChatFormatting.WHITE);
        source.sendSuccess(() -> FTBRanksCommands.lambda$showRank$49((Component)c), false);
        source.sendSuccess(() -> Component.literal((String)"Permission nodes:").withStyle(ChatFormatting.YELLOW), false);
        rank.getPermissions().stream().sorted().forEach(node -> source.sendSuccess(() -> Component.literal((String)(" - " + node + ": " + String.valueOf(rank.getPermission((String)node)))), false));
        return 0;
    }

    private static Rank getRank(String rankName) throws CommandSyntaxException {
        return FTBRanksAPI.manager().getRank(rankName).orElseThrow(() -> ERROR_UNKNOWN_RANK.create((Object)rankName));
    }

    private static /* synthetic */ Component lambda$showRank$49(Component c) {
        return Component.literal((String)"Condition: ").append(c).withStyle(ChatFormatting.YELLOW);
    }
}

