/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.block.entity.neoforge;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackListGetter;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValhelsiaContainerBlockEntity<T extends BlockEntity>
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int DEFAULT_MAX_STACK_SIZE = 64;
    private final ItemStackHandler itemStackHandler;
    private LockCode lockKey = LockCode.NO_LOCK;
    private Component name;

    public ValhelsiaContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        this(type, pos, state, inventorySize, (ToBooleanBiFunction<Integer, ItemStack>)((ToBooleanBiFunction)(integer, stack) -> true));
    }

    public ValhelsiaContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, final ToBooleanBiFunction<Integer, ItemStack> isItemValid) {
        super(type, pos, state);
        this.itemStackHandler = new ItemStackHandler(this, inventorySize){
            final /* synthetic */ ValhelsiaContainerBlockEntity this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.onSlotChanged(slot);
                this.this$0.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return isItemValid.applyAsBoolean((Object)slot, (Object)stack);
            }
        };
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    protected void onSlotChanged(int slot) {
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.lockKey = LockCode.fromTag((CompoundTag)tag);
        if (tag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)lookupProvider);
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        this.lockKey.addToTag(tag);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookupProvider));
        }
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    @Nonnull
    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @Nonnull
    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected abstract Component getDefaultName();

    public boolean canOpen(Player player) {
        return ValhelsiaContainerBlockEntity.canUnlock(player, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(Player player, LockCode code, Component displayName) {
        if (!player.isSpectator() && !code.unlocksWith(player.getMainHandItem())) {
            player.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{displayName}), true);
            player.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
        return this.canOpen(player) ? this.createMenu(containerId, MenuCreationContext.of(inventory, this.level, this.worldPosition, player)) : null;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, @Nonnull MenuCreationContext<T, IItemHandler> var2);

    public int getMaxStackSize() {
        return 64;
    }

    public ItemStack getStack(int slot) {
        return this.itemStackHandler.getStackInSlot(slot);
    }

    public NonNullList<ItemStack> getStacks() {
        ItemStackHandler itemStackHandler = this.itemStackHandler;
        if (itemStackHandler instanceof ItemStackListGetter) {
            ItemStackListGetter itemStackListGetter = (ItemStackListGetter)itemStackHandler;
            return itemStackListGetter.getStacks();
        }
        return NonNullList.create();
    }

    public void setStack(int slot, ItemStack stack) {
        this.itemStackHandler.setStackInSlot(slot, stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void saveInventory(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.put("Inventory", (Tag)this.itemStackHandler.serializeNBT(lookupProvider));
    }

    public void loadInventory(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.itemStackHandler.deserializeNBT(lookupProvider, tag.getCompound("Inventory"));
    }
}

