/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.fight;

import com.cupboard.util.BlockSearch;
import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.config.ConfigurationCache;
import com.dragonfight.fight.CrystalLevelData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonDeathPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DragonFightManagerCustom {
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnCrystalDeath = ImmutableList.of();
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnCrystalRespawn = ImmutableList.of();
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnDragonSitting = ImmutableList.of();
    private static final float CRYSTAL_RESPAWN_TIME = 8000.0f;
    private static final int LIGHTNING_DESTROY_RANGE = 100;
    private static final int ADD_TIMER = 2000;
    private static BlockPos crystalRespawnPos = null;
    private static int crystalRespawnTimer = 0;
    private static int timeSinceLastLanding = 0;
    private static boolean spawnAdds = false;
    private static final BlockPos spawnPos = new BlockPos(0, 68, 0);
    private static int spawnCounter = 0;
    private static List<LivingEntity> meleeAdds = new ArrayList<LivingEntity>();
    private static int advancingLightningCurrent = 0;
    private static int advancingLightningStop = 0;
    private static int advancingExplosionCurrent = 0;
    private static int advancingExplosionStop = 0;
    private static EnderDragon dragonEntity = null;
    public static boolean isFightRunning = true;
    static final ResourceLocation GRAVITY_MOD_ID = DragonfightMod.id("fall");
    static final ResourceLocation HP_MOD_ID = DragonfightMod.id("dragonhp");
    public static AttributeModifier AA_GRAVITY_MOD = new AttributeModifier(GRAVITY_MOD_ID, 5.0, AttributeModifier.Operation.ADD_VALUE);
    private static AttributeModifier MAX_HP_MOD = new AttributeModifier(HP_MOD_ID, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static Map<UUID, Integer> flyingPlayers = new HashMap<UUID, Integer>();

    public static void onCrystalDeath(EndCrystal enderCrystalEntity, DamageSource damageSource) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(enderCrystalEntity.level(), enderCrystalEntity.getX(), enderCrystalEntity.getY(), enderCrystalEntity.getZ());
        if (dragonEntity != null) {
            areaeffectcloudentity.setOwner((LivingEntity)dragonEntity);
        }
        DragonFightManagerCustom.notifyPlayer(enderCrystalEntity.level(), "Crystal died from:" + String.valueOf(damageSource));
        areaeffectcloudentity.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        areaeffectcloudentity.setRadius(1.0f);
        areaeffectcloudentity.setDuration((int)((double)(8000.0f / (float)DragonFightManagerCustom.getDifficulty()) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).crystalRespawnTimeModifier));
        areaeffectcloudentity.setRadiusPerTick((5.0f - areaeffectcloudentity.getRadius()) / (float)areaeffectcloudentity.getDuration());
        areaeffectcloudentity.addEffect(new MobEffectInstance(MobEffects.HARM, 100, 1));
        areaeffectcloudentity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 1));
        areaeffectcloudentity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 1));
        enderCrystalEntity.level().addFreshEntity((Entity)areaeffectcloudentity);
        DragonFightManagerCustom.addCrystalRespawnPos(enderCrystalEntity.blockPosition());
        if (!(damageSource.getEntity() instanceof Player)) {
            return;
        }
        if (damageSource.getEntity().blockPosition().distSqr((Vec3i)enderCrystalEntity.blockPosition()) > 100.0) {
            if (!((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning) {
                LightningBolt lightningboltentity = (LightningBolt)DragonFightManagerCustom.spawnEntity((ServerLevel)enderCrystalEntity.level(), new ConfigurationCache.EntitySpawnData(EntityType.LIGHTNING_BOLT, null), damageSource.getEntity().position());
                lightningboltentity.setVisualOnly(false);
            }
            if (!spawnOnCrystalDeath.isEmpty()) {
                int i = 0;
                while ((double)i < Math.max(1.0, (double)DragonFightManagerCustom.getDifficulty() / 4.0 * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier)) {
                    LivingEntity entity;
                    BlockPos searchedPos = BlockSearch.findAround((BlockGetter)enderCrystalEntity.level(), (BlockPos)damageSource.getEntity().blockPosition().offset(i + 1, 5, i + 1), (int)15, (int)15, (int)1, (level, checkPos) -> level.getBlockState(checkPos).isAir() && level.getBlockState(checkPos.above()).isAir());
                    if (searchedPos == null) {
                        searchedPos = damageSource.getEntity().blockPosition();
                    }
                    if ((entity = (LivingEntity)DragonFightManagerCustom.spawnEntity((ServerLevel)enderCrystalEntity.level(), (ConfigurationCache.EntitySpawnData)spawnOnCrystalDeath.get(DragonfightMod.rand.nextInt(spawnOnCrystalDeath.size())), DragonFightManagerCustom.createVec3(searchedPos))) instanceof Mob) {
                        ((Mob)entity).setTarget((LivingEntity)damageSource.getEntity());
                    }
                    ++i;
                }
            }
        } else if (dragonEntity != null && dragonEntity.getHealth() > 100.0f) {
            dragonEntity.setHealth(dragonEntity.getHealth() * 0.9f);
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            dragonEntity.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, dragonEntity.getX() + (double)f, dragonEntity.getY() + 2.0 + (double)f1, dragonEntity.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
    }

    private static void addCrystalRespawnPos(BlockPos position) {
        if (dragonEntity == null || Math.sqrt(dragonEntity.blockPosition().distSqr((Vec3i)position)) > 1000.0) {
            return;
        }
        CrystalLevelData.getForLevel((ServerLevel)dragonEntity.level()).addPosition(position);
    }

    private static Set<BlockPos> getCrystalRespawnPositions(ServerLevel level) {
        HashSet<BlockPos> existing = new HashSet<BlockPos>();
        for (BlockPos pos : CrystalLevelData.getForLevel(level).getCrystalPendingRespawns()) {
            if (dragonEntity != null && Math.sqrt(dragonEntity.blockPosition().distSqr((Vec3i)pos)) > 1000.0) continue;
            existing.add(pos);
        }
        return existing;
    }

    public static void onWorldTick(Level world) {
        EndDragonFight manager = ((ServerLevel)world).getDragonFight();
        if (manager == null || manager.dragonEvent.getPlayers().isEmpty() || dragonEntity == null) {
            DragonFightManagerCustom.reset();
            return;
        }
        if (crystalRespawnPos != null) {
            if (--crystalRespawnTimer > 0) {
                if (crystalRespawnTimer == 200) {
                    DragonFightManagerCustom.spawnLightningAtCircle(crystalRespawnPos, 5, world);
                }
            } else {
                DragonFightManagerCustom.notifyPlayer(world, "Respawning crystal at" + String.valueOf(crystalRespawnPos));
                DragonFightManagerCustom.respawnCrystalAt(crystalRespawnPos, world);
            }
        }
        if (dragonEntity.getHealth() < dragonEntity.getMaxHealth() && dragonEntity.isAlive()) {
            if (!isFightRunning && !manager.dragonEvent.getPlayers().isEmpty()) {
                List monsterEntities = world.getEntitiesOfClass(Monster.class, dragonEntity.getBoundingBox().inflate(150.0));
                for (Monster entity : monsterEntities) {
                    if (entity instanceof Npc || entity.isPersistenceRequired()) continue;
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                DragonFightManagerCustom.setDragonHealth();
                isFightRunning = true;
            }
        } else {
            if (isFightRunning) {
                DragonFightManagerCustom.reset();
            }
            isFightRunning = false;
        }
        if (!isFightRunning) {
            return;
        }
        if (dragonEntity.getPhaseManager().getCurrentPhase() instanceof DragonDeathPhase && dragonEntity.getPhaseManager().getCurrentPhase().getFlyTargetLocation() != null && dragonEntity.getPhaseManager().getCurrentPhase().getFlyTargetLocation().distanceToSqr((double)dragonEntity.blockPosition().getX(), (double)dragonEntity.blockPosition().getY(), dragonEntity.getZ()) < 10.0) {
            dragonEntity.setHealth(0.0f);
        }
        if (++timeSinceLastLanding > 2400 && dragonEntity != null) {
            timeSinceLastLanding = 0;
            dragonEntity.getPhaseManager().setPhase(EnderDragonPhase.LANDING_APPROACH);
            DragonFightManagerCustom.notifyPlayer(world, "Forcing landing phase");
        }
        if ((double)dragonEntity.getHealth() > (double)dragonEntity.getMaxHealth() * 0.9) {
            return;
        }
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).antiflightAbility) {
            for (Player player : manager.dragonEvent.getPlayers()) {
                int time = flyingPlayers.computeIfAbsent(player.getUUID(), s -> 0);
                if (DragonFightManagerCustom.isFlying(player)) {
                    if (time == 300) {
                        player.getAttribute(Attributes.GRAVITY).addTransientModifier(AA_GRAVITY_MOD);
                        flyingPlayers.put(player.getUUID(), ++time);
                        continue;
                    }
                    if (time > 400) {
                        player.hurt(dragonEntity.damageSources().fall(), player.getMaxHealth() * 0.9f);
                        player.setHealth(1.0f);
                        player.getAttribute(Attributes.GRAVITY).removeModifier(AA_GRAVITY_MOD);
                        flyingPlayers.put(player.getUUID(), 0);
                        continue;
                    }
                    if (time == 100) {
                        player.getAttribute(Attributes.GRAVITY).removeModifier(AA_GRAVITY_MOD);
                    }
                    flyingPlayers.put(player.getUUID(), ++time);
                    continue;
                }
                if (time > 300) {
                    player.hurt(dragonEntity.damageSources().fall(), player.getMaxHealth() * 0.9f);
                    player.setHealth(1.0f);
                    player.getAttribute(Attributes.GRAVITY).removeModifier(AA_GRAVITY_MOD);
                }
                flyingPlayers.put(player.getUUID(), 0);
            }
        }
        if (advancingLightningCurrent > 0 && world.getGameTime() % 100L == 0L) {
            DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, advancingLightningCurrent += 3, world);
            if (advancingLightningCurrent > advancingLightningStop) {
                advancingLightningCurrent = 0;
                advancingLightningStop = 0;
            }
        }
        if (dragonEntity != null && advancingExplosionCurrent == 0 && advancingLightningCurrent == 0) {
            double d = dragonEntity.getHealth() / dragonEntity.getMaxHealth();
            double d2 = ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning ? 0.5 : 0.2;
            if (d < d2) {
                advancingExplosionCurrent = 8;
                advancingExplosionStop = 50;
            }
        }
        if (advancingExplosionCurrent > 0 && world.getGameTime() % 200L == 0L) {
            DragonFightManagerCustom.explodeInCircleAround(spawnPos, advancingExplosionCurrent += 3, world);
            if (advancingExplosionCurrent > advancingExplosionStop) {
                advancingExplosionCurrent = 0;
                advancingExplosionStop = 0;
            }
        }
        if (spawnAdds) {
            int n = spawnCounter++;
            if ((double)n > 2000.0 / ((double)DragonFightManagerCustom.getDifficulty() * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier)) {
                DragonFightManagerCustom.notifyPlayer(world, "Spawning melee add");
                DragonFightManagerCustom.spawnMeleeAdds(world);
                spawnCounter = 0;
            }
        }
    }

    private static void setDragonHealth() {
        double pct = dragonEntity.getHealth() / dragonEntity.getMaxHealth();
        if (dragonEntity.getAttribute(Attributes.MAX_HEALTH).hasModifier(HP_MOD_ID)) {
            dragonEntity.getAttribute(Attributes.MAX_HEALTH).removeModifier(HP_MOD_ID);
        }
        MAX_HP_MOD = new AttributeModifier(HP_MOD_ID, (double)Math.max(1, DragonFightManagerCustom.getDifficulty() / 5) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonHealthModifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        dragonEntity.getAttribute(Attributes.MAX_HEALTH).addTransientModifier(MAX_HP_MOD);
        dragonEntity.setHealth((float)((double)dragonEntity.getMaxHealth() * pct));
    }

    private static boolean isFlying(Player player) {
        return player != null && (player.hasImpulse || !player.onGround()) && player.fallDistance <= 0.1f && player.level().isEmptyBlock(player.blockPosition().below(2));
    }

    private static void reset() {
        crystalRespawnPos = null;
        spawnAdds = false;
        spawnCounter = 0;
        for (LivingEntity living : meleeAdds) {
            living.remove(Entity.RemovalReason.DISCARDED);
        }
        if (dragonEntity != null) {
            for (UUID playerUUID : flyingPlayers.keySet()) {
                ServerPlayer player = dragonEntity.level().getServer().getPlayerList().getPlayer(playerUUID);
                if (player == null) continue;
                player.getAttribute(Attributes.GRAVITY).removeModifier(AA_GRAVITY_MOD);
            }
        }
        flyingPlayers.clear();
        meleeAdds.clear();
    }

    private static void spawnMeleeAdds(Level world) {
        LivingEntity entity;
        meleeAdds.removeIf(Entity::isRemoved);
        if ((double)meleeAdds.size() >= (double)DragonFightManagerCustom.getDifficulty() * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier || spawnOnDragonSitting.isEmpty()) {
            return;
        }
        BlockPos searchedPos = BlockSearch.findAround((BlockGetter)world, (BlockPos)spawnPos, (int)30, (int)30, (int)1, (level, checkPos) -> level.getBlockState(checkPos).isAir() && level.getBlockState(checkPos.above()).isAir() && level.getBlockState(checkPos.below()).isSolid());
        if (searchedPos == null) {
            searchedPos = spawnPos;
        }
        if ((entity = (LivingEntity)DragonFightManagerCustom.spawnEntity((ServerLevel)world, (ConfigurationCache.EntitySpawnData)spawnOnDragonSitting.get(DragonfightMod.rand.nextInt(spawnOnDragonSitting.size())), DragonFightManagerCustom.createVec3(searchedPos))) instanceof Mob) {
            List closesPlayers = world.getNearbyPlayers(TargetingConditions.DEFAULT, entity, entity.getBoundingBox().inflate(20.0));
            if (!closesPlayers.isEmpty()) {
                Player closestPlayer = (Player)closesPlayers.get(DragonfightMod.rand.nextInt(closesPlayers.size()));
                ((Mob)entity).setTarget((LivingEntity)closestPlayer);
            }
        } else {
            List farPlayers = world.getNearbyPlayers(TargetingConditions.DEFAULT, entity, entity.getBoundingBox().inflate(60.0, 120.0, 60.0));
            if (!farPlayers.isEmpty()) {
                Player closestPlayer = (Player)farPlayers.get(DragonfightMod.rand.nextInt(farPlayers.size()));
                ((Mob)entity).setTarget((LivingEntity)closestPlayer);
            }
        }
        meleeAdds.add(entity);
    }

    private static void respawnCrystalAt(BlockPos pos, Level world) {
        if (world.getEntitiesOfClass(EndCrystal.class, new AABB(pos).inflate(2.0)).isEmpty()) {
            EndCrystal crystal = (EndCrystal)DragonFightManagerCustom.spawnEntity((ServerLevel)world, new ConfigurationCache.EntitySpawnData(EntityType.END_CRYSTAL, null), DragonFightManagerCustom.createVec3(pos));
            Vec3 spawnPos = DragonFightManagerCustom.createVec3(new BlockPos((int)((double)pos.getX() * 0.8), pos.getY(), (int)((double)pos.getZ() * 0.8)));
            if (!spawnOnCrystalRespawn.isEmpty()) {
                int i = 0;
                while ((double)i < Math.max(1.0, (double)DragonFightManagerCustom.getDifficulty() / 3.0 * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier)) {
                    Entity entity = DragonFightManagerCustom.spawnEntity((ServerLevel)world, (ConfigurationCache.EntitySpawnData)spawnOnCrystalRespawn.get(DragonfightMod.rand.nextInt(spawnOnCrystalRespawn.size())), spawnPos.add(0.0, (double)i, 0.0));
                    if (entity instanceof Mob) {
                        ((Mob)entity).setTarget((LivingEntity)world.getNearestPlayer(entity, 100.0));
                    }
                    ++i;
                }
            }
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, crystal.getX() + (double)f, crystal.getY() + 2.0 + (double)f1, crystal.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        CrystalLevelData.getForLevel((ServerLevel)world).removePosition(crystalRespawnPos);
        crystalRespawnPos = null;
        DragonFightManagerCustom.checkCrystalsToRespawn(world);
    }

    public static void onDragonHeal(EnderDragon dragonEntity) {
        dragonEntity.setHealth(Math.min(dragonEntity.getMaxHealth(), dragonEntity.getHealth() + (float)DragonFightManagerCustom.getDifficulty() / 7.0f));
    }

    public static float onAttackPlayer(float damage) {
        return (float)((double)(damage + (float)DragonFightManagerCustom.getDifficulty() / 2.0f) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDamageModifier);
    }

    public static void onPhaseChange(EnderDragonPhase<?> newPhase, EnderDragonPhase<? extends DragonPhaseInstance> oldphase, EnderDragon dragon) {
        if (dragonEntity != dragon) {
            dragonEntity = dragon;
            return;
        }
        if (dragon == null || !(dragon.level() instanceof ServerLevel) || !dragonEntity.isAlive()) {
            return;
        }
        EndDragonFight manager = ((ServerLevel)dragon.level()).getDragonFight();
        if (manager == null || manager.dragonEvent.getPlayers().isEmpty()) {
            return;
        }
        DragonFightManagerCustom.notifyPlayer(dragon.level(), "Next phase:" + newPhase.toString());
        if (newPhase == EnderDragonPhase.TAKEOFF) {
            spawnAdds = true;
            DragonFightManagerCustom.checkCrystalsToRespawn(dragon.level());
            if ((double)(dragon.getHealth() / dragon.getMaxHealth()) < 0.25 && dragon.getDragonFight() != null) {
                dragon.level().playLocalSound(dragon.getX(), dragon.getY(), dragon.getZ(), SoundEvents.ENDER_DRAGON_GROWL, dragon.getSoundSource(), 2.5f, 0.8f + DragonfightMod.rand.nextFloat() * 0.3f, false);
                for (Player playerEntity : dragon.getDragonFight().dragonEvent.getPlayers()) {
                    playerEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, DragonFightManagerCustom.getDifficulty() / 3));
                    if (!((double)(dragon.getHealth() / dragon.getMaxHealth()) < 0.1)) continue;
                    playerEntity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200, 1));
                }
            }
        }
        if (newPhase == EnderDragonPhase.LANDING_APPROACH || newPhase == EnderDragonPhase.DYING) {
            timeSinceLastLanding = 0;
            spawnAdds = false;
        }
        if (oldphase == EnderDragonPhase.LANDING && newPhase == EnderDragonPhase.SITTING_SCANNING) {
            timeSinceLastLanding = 0;
            double healthpercent = dragon.getHealth() / dragon.getMaxHealth();
            if (healthpercent < 0.5) {
                advancingLightningCurrent = 6;
                advancingLightningStop = 50;
            } else {
                DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, DragonfightMod.rand.nextInt(16) + 8, dragon.level());
            }
        }
    }

    private static void checkCrystalsToRespawn(Level world) {
        if (crystalRespawnPos != null) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(DragonFightManagerCustom.getCrystalRespawnPositions((ServerLevel)world));
        Collections.shuffle(positions);
        for (BlockPos pos : positions) {
            if (!world.getEntitiesOfClass(EndCrystal.class, new AABB(pos).inflate(5.0)).isEmpty()) continue;
            crystalRespawnPos = pos;
            crystalRespawnTimer = (int)Math.max(400.0, (double)(8000.0f / (float)DragonFightManagerCustom.getDifficulty()) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).crystalRespawnTimeModifier);
            DragonFightManagerCustom.notifyPlayer(world, "Adding respawn at :" + String.valueOf(crystalRespawnPos) + " in:" + crystalRespawnTimer);
            break;
        }
    }

    private static void spawnLightningAtCircle(BlockPos midPoint, int radius, Level world) {
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning) {
            return;
        }
        Set<BlockPos> lightningPositions = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15 - radius / 10);
        for (BlockPos lightningPos : lightningPositions) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning plightning at!" + String.valueOf(new BlockPos(lightningPos.getX(), world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, lightningPos).getY(), lightningPos.getZ())));
            int yLevel = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, lightningPos).getY();
            if (Math.abs(midPoint.getY() - yLevel) > 20) continue;
            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world);
            lightningboltentity.moveTo((double)lightningPos.getX(), (double)yLevel, (double)lightningPos.getZ());
            lightningboltentity.setVisualOnly(false);
            world.addFreshEntity((Entity)lightningboltentity);
        }
    }

    private static void explodeInCircleAround(BlockPos midPoint, int radius, Level world) {
        Set<BlockPos> explodePos = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15);
        for (BlockPos lightningPos : explodePos) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning explosion at!" + String.valueOf(new BlockPos(lightningPos.getX(), world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, lightningPos).getY(), lightningPos.getZ())));
            int yLevel = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, lightningPos).getY();
            if (Math.abs(midPoint.getY() - yLevel) > 20) continue;
            world.explode((Entity)dragonEntity, (double)lightningPos.getX(), (double)lightningPos.getY(), (double)lightningPos.getZ(), (float)(1 + DragonFightManagerCustom.getDifficulty() / 4), false, Level.ExplosionInteraction.NONE);
        }
    }

    private static Set<BlockPos> getCircularPositionsAround(BlockPos start, int radius, int precision) {
        int randomOffset;
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        precision = (int)((double)precision / ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).lightningExplosionDensity);
        for (int i = randomOffset = DragonfightMod.rand.nextInt(40); i < 360 + randomOffset; i += precision) {
            int x = (int)Math.round((double)radius * Math.cos(Math.toRadians(i)));
            int z = (int)Math.round((double)radius * Math.sin(Math.toRadians(i)));
            positions.add(start.offset(x, 0, z));
        }
        return positions;
    }

    public static void notifyPlayer(Level world, String message) {
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).printDragonPhases) {
            for (Player player : ((ServerLevel)world).players()) {
                if (world.getServer() == null || ((ServerLevel)world).getServer().getProfilePermissions(player.getGameProfile()) <= 0) continue;
                player.sendSystemMessage((Component)Component.literal((String)message));
            }
        }
    }

    private static int getDifficulty() {
        int difficulty = ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDifficulty;
        if (dragonEntity != null) {
            difficulty += dragonEntity.level().getDifficulty().getId();
            if (dragonEntity.getDragonFight() != null) {
                difficulty += DragonFightManagerCustom.dragonEntity.getDragonFight().dragonEvent.getPlayers().size();
            }
        }
        return Math.max(difficulty, 1);
    }

    private static Vec3 createVec3(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    private static Entity spawnEntity(ServerLevel world, ConfigurationCache.EntitySpawnData spawnData, Vec3 pos) {
        CompoundTag compoundtag = new CompoundTag();
        if (spawnData.nbt != null) {
            compoundtag = spawnData.nbt.copy();
        }
        compoundtag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)spawnData.type).toString());
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)world, p_138828_ -> {
            double offset = pos.x % 1.0 != 0.0 || pos.z % 1.0 != 0.0 ? 0.0 : 0.5;
            p_138828_.moveTo(pos.x + offset, pos.y, pos.z + offset, p_138828_.getYRot(), p_138828_.getXRot());
            return p_138828_;
        });
        if (entity == null) {
            return null;
        }
        entity.setUUID(UUID.randomUUID());
        if (entity instanceof Mob) {
            ((Mob)entity).finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.COMMAND, (SpawnGroupData)null);
        }
        world.addFreshEntity(entity);
        return entity;
    }
}

