/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.fight;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class CrystalLevelData
extends SavedData {
    public static final String ID = "dragonfight";
    private final Set<BlockPos> crystalPendingRespawns = new HashSet<BlockPos>();

    public static CrystalLevelData load(CompoundTag tag) {
        CrystalLevelData data = new CrystalLevelData();
        data.read(tag);
        return data;
    }

    public void read(CompoundTag nbt) {
        ListTag list = nbt.getList("positions", 10);
        this.crystalPendingRespawns.clear();
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            this.crystalPendingRespawns.add(new BlockPos(((CompoundTag)tag).getInt("x"), ((CompoundTag)tag).getInt("y"), ((CompoundTag)tag).getInt("z")));
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (BlockPos data : this.crystalPendingRespawns) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", data.getX());
            tag.putInt("y", data.getY());
            tag.putInt("z", data.getZ());
            list.add((Object)tag);
        }
        nbt.put("positions", (Tag)list);
        this.setDirty(false);
        return nbt;
    }

    public void addPosition(BlockPos pos) {
        this.setDirty();
        this.crystalPendingRespawns.add(pos);
    }

    public void removePosition(BlockPos pos) {
        this.setDirty();
        this.crystalPendingRespawns.remove(pos);
    }

    public Set<BlockPos> getCrystalPendingRespawns() {
        return this.crystalPendingRespawns;
    }

    public static CrystalLevelData getForLevel(ServerLevel level) {
        return (CrystalLevelData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(CrystalLevelData::new, (nbt, provider) -> CrystalLevelData.load(nbt), DataFixTypes.LEVEL), ID);
    }
}

