/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.mekanism.ChemicalCapabilityCache;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import java.util.Collection;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChemicalPatternProviderExternalPatternSink
implements PlatformPatternProviderExternalPatternSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChemicalPatternProviderExternalPatternSink.class);
    private final ChemicalCapabilityCache capabilityCache;

    ChemicalPatternProviderExternalPatternSink(ChemicalCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        return this.capabilityCache.getCapability().map(handler -> this.accept(resources, action, (IChemicalHandler)handler)).orElse(ExternalPatternSink.Result.SKIPPED);
    }

    private ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action, IChemicalHandler handler) {
        for (ResourceAmount resource : resources) {
            ResourceKey resourceKey = resource.resource();
            if (!(resourceKey instanceof ChemicalResource)) continue;
            ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
            if (this.accept(action, handler, resource.amount(), chemicalResource)) continue;
            return ExternalPatternSink.Result.REJECTED;
        }
        return ExternalPatternSink.Result.ACCEPTED;
    }

    private boolean accept(Action action, IChemicalHandler handler, long amount, ChemicalResource chemicalResource) {
        ChemicalStack stack = new ChemicalStack(chemicalResource.chemical(), amount);
        ChemicalStack remainder = handler.insertChemical(stack, ChemicalUtil.toMekanismAction(action));
        if (!remainder.isEmpty()) {
            if (action == Action.EXECUTE) {
                LOGGER.warn("{} unexpectedly didn't accept all of {}, the remainder has been voided", (Object)handler, (Object)stack);
            }
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.capabilityCache.getCapability().map(handler -> {
            for (int i = 0; i < handler.getChemicalTanks(); ++i) {
                if (handler.getChemicalInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }
}

