/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.level.attachments;

import com.mojang.serialization.Codec;
import com.unrealdinnerbone.weathergate.WeatherGateRegistry;
import com.unrealdinnerbone.weathergate.util.RangeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;

public record SunInABlockAttachment(List<BlockPos> blockPosList) {
    public static final SunInABlockAttachment EMPTY = new SunInABlockAttachment(new ArrayList<BlockPos>());
    public static final Codec<SunInABlockAttachment> CODEC = BlockPos.CODEC.listOf().xmap(SunInABlockAttachment::of, SunInABlockAttachment::blockPosList);

    public static SunInABlockAttachment of(List<BlockPos> data) {
        return new SunInABlockAttachment(new ArrayList<BlockPos>(data));
    }

    public static SunInABlockAttachment get(Level level) {
        return (SunInABlockAttachment)level.getData((AttachmentType)WeatherGateRegistry.SUN_IN_A_BOX_ATTACHMENT.get());
    }

    public void save(Level level) {
        level.setData((AttachmentType)WeatherGateRegistry.SUN_IN_A_BOX_ATTACHMENT.get(), (Object)this);
    }

    public static void addBlockPos(Level level, BlockPos blockPos) {
        SunInABlockAttachment snowCatcherAttachment = SunInABlockAttachment.get(level);
        snowCatcherAttachment.blockPosList.add(blockPos);
        snowCatcherAttachment.save(level);
    }

    public static void removeBlockPos(Level level, BlockPos blockPos) {
        SunInABlockAttachment snowCatcherAttachment = SunInABlockAttachment.get(level);
        snowCatcherAttachment.blockPosList.remove(blockPos);
        snowCatcherAttachment.save(level);
    }

    public static boolean isInRange(Level level, Vec3i blockPos) {
        for (BlockPos location : SunInABlockAttachment.get(level).blockPosList()) {
            if (!RangeUtils.isWithinRange((Vec3i)location, blockPos, 64)) continue;
            return true;
        }
        return false;
    }

    public List<GlobalPos> toGlobalPos(ResourceKey<Level> level) {
        return this.blockPosList.stream().map(blockPos -> GlobalPos.of((ResourceKey)level, (BlockPos)blockPos)).collect(Collectors.toList());
    }
}

