/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.BooleanConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigResponseMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlockEntity
extends BlockEntity
implements ITaskScreen {
    private long taskId = 0L;
    private Task task = null;
    private boolean indestructible = false;
    private boolean inputOnly = false;
    private boolean textShadow = false;
    private ItemStack inputModeIcon = ItemStack.EMPTY;
    private ItemStack skin = ItemStack.EMPTY;
    @NotNull
    private UUID teamId = Util.NIL_UUID;
    public float[] fakeTextureUV = null;
    private TeamData cachedTeamData = null;

    public TaskScreenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.CORE_TASK_SCREEN.get(), blockPos, blockState);
    }

    public Task getTask() {
        if (this.task == null && this.taskId != 0L || this.task != null && this.task.id != this.taskId) {
            this.task = FTBQuestsAPI.api().getQuestFile(this.level.isClientSide).getTask(this.taskId);
        }
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.taskId = task == null ? 0L : task.id;
        this.setChanged();
    }

    @Override
    public boolean isInputOnly() {
        return this.inputOnly;
    }

    public void setInputOnly(boolean inputOnly) {
        this.inputOnly = inputOnly;
        this.setChanged();
    }

    public ItemStack getInputModeIcon() {
        return this.inputModeIcon;
    }

    public void setInputModeIcon(ItemStack inputModeIcon) {
        this.inputModeIcon = inputModeIcon;
        this.setChanged();
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    public void setIndestructible(boolean indestructible) {
        this.indestructible = indestructible;
        this.setChanged();
    }

    @Override
    public ItemStack getSkin() {
        return this.skin;
    }

    public void setSkin(ItemStack skin) {
        this.skin = skin;
        this.fakeTextureUV = null;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void setTeamId(@NotNull UUID teamId) {
        this.teamId = teamId;
        this.cachedTeamData = null;
    }

    @Override
    @NotNull
    public UUID getTeamId() {
        return this.teamId;
    }

    public TeamData getCachedTeamData() {
        if (this.cachedTeamData == null) {
            BaseQuestFile f = FTBQuestsAPI.api().getQuestFile(this.level.isClientSide);
            this.cachedTeamData = f.getNullableTeamData(this.getTeamId());
        }
        return this.cachedTeamData;
    }

    @Override
    public Optional<TaskScreenBlockEntity> getCoreScreen() {
        return Optional.of(this);
    }

    public void removeAllAuxScreens() {
        Block block;
        if (this.level != null && (block = this.getBlockState().getBlock()) instanceof TaskScreenBlock) {
            TaskScreenBlock tsb = (TaskScreenBlock)block;
            BlockPos.betweenClosedStream((BoundingBox)TaskScreenBlock.getMultiblockBounds(this.getBlockPos(), tsb.getSize(), (Direction)this.getBlockState().getValue((Property)TaskScreenBlock.FACING))).forEach(pos -> {
                if (this.level.getBlockState(pos).getBlock() == ModBlocks.AUX_SCREEN.get()) {
                    this.level.removeBlock(pos, false);
                }
            });
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.teamId = compoundTag.hasUUID("TeamID") ? compoundTag.getUUID("TeamID") : Util.NIL_UUID;
        TaskScreenSaveData data = TaskScreenSaveData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getCompound("savedData")).result().orElse(TaskScreenSaveData.DEFAULT);
        this.applySavedData(data);
        this.task = null;
        this.fakeTextureUV = null;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.teamId != Util.NIL_UUID) {
            compoundTag.putUUID("TeamID", this.teamId);
        }
        TaskScreenSaveData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)TaskScreenSaveData.fromBlockEntity(this)).ifSuccess(tag -> compoundTag.put("savedData", tag));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        this.applySavedData((TaskScreenSaveData)dataComponentInput.getOrDefault((DataComponentType)ModDataComponents.TASK_SCREEN_SAVED.get(), (Object)TaskScreenSaveData.DEFAULT));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)ModDataComponents.TASK_SCREEN_SAVED.get(), (Object)TaskScreenSaveData.fromBlockEntity(this));
    }

    private void applySavedData(TaskScreenSaveData data) {
        this.taskId = data.taskId;
        this.skin = data.skin;
        this.indestructible = data.indestructible;
        this.inputOnly = data.inputOnly;
        this.inputModeIcon = data.inputModeIcon;
        this.textShadow = data.textShadow;
    }

    public ConfigGroup fillConfigGroup(TeamData data) {
        ConfigGroup cg0 = new ConfigGroup("task_screen", accepted -> {
            if (accepted) {
                NetworkManager.sendToServer((CustomPacketPayload)new TaskScreenConfigResponseMessage(this.getBlockPos(), this.saveWithoutMetadata((HolderLookup.Provider)this.getLevel().registryAccess())));
            }
        });
        cg0.setNameKey(this.getBlockState().getBlock().getDescriptionId());
        ConfigGroup cg = cg0.getOrCreateSubgroup("screen");
        ((ConfigQuestObject)cg.add("task", new ConfigQuestObject<Task>(o -> this.isSuitableTask(data, (QuestObjectBase)o), this::formatLine), (Object)this.getTask(), this::setTask, null)).setNameKey("ftbquests.task");
        ((ItemStackConfig)cg.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)ItemStack.EMPTY)).setNameKey("block.ftbquests.screen.skin");
        ((BooleanConfig)cg.add("text_shadow", (ConfigValue)new BooleanConfig(), (Object)this.isTextShadow(), this::setTextShadow, (Object)false)).setNameKey("block.ftbquests.screen.text_shadow");
        ((BooleanConfig)cg.add("indestructible", (ConfigValue)new BooleanConfig(), (Object)this.isIndestructible(), this::setIndestructible, (Object)false)).setNameKey("block.ftbquests.screen.indestructible");
        ((BooleanConfig)cg.add("input_only", (ConfigValue)new BooleanConfig(), (Object)this.isInputOnly(), this::setInputOnly, (Object)false)).setNameKey("block.ftbquests.screen.input_only");
        ((ItemStackConfig)cg.add("input_icon", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getInputModeIcon(), this::setInputModeIcon, (Object)ItemStack.EMPTY)).setNameKey("block.ftbquests.screen.input_mode_icon");
        return cg0;
    }

    private Component formatLine(Task task) {
        if (this.task == null) {
            return Component.empty();
        }
        MutableComponent questTxt = Component.literal((String)" [").append(task.getQuest().getTitle()).append("]").withStyle(ChatFormatting.GREEN);
        return ConfigQuestObject.formatEntry(task).copy().append((Component)questTxt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuitableTask(TeamData data, QuestObjectBase o) {
        if (!(o instanceof Task)) return false;
        Task t = (Task)o;
        if (!data.getCanEdit(FTBQuestsClient.getClientPlayer())) {
            if (!data.canStartTasks(t.getQuest())) return false;
        }
        if (!t.consumesResources()) return false;
        return true;
    }

    public float[] getFakeTextureUV() {
        if (this.fakeTextureUV == null) {
            Item item;
            if (!this.skin.isEmpty() && (item = this.skin.getItem()) instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                BlockState state = bi.getBlock().defaultBlockState();
                Direction facing = (Direction)this.getBlockState().getValue((Property)TaskScreenBlock.FACING);
                if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
                }
                this.fakeTextureUV = FTBQuestsClient.getTextureUV(state, facing);
            } else {
                this.fakeTextureUV = new float[0];
            }
        }
        return this.fakeTextureUV;
    }

    public record TaskScreenSaveData(long taskId, ItemStack skin, boolean indestructible, boolean inputOnly, ItemStack inputModeIcon, boolean textShadow) {
        public static TaskScreenSaveData DEFAULT = new TaskScreenSaveData(0L, ItemStack.EMPTY, false, false, ItemStack.EMPTY, false);
        public static final Codec<TaskScreenSaveData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.optionalFieldOf("taskId", (Object)0L).forGetter(TaskScreenSaveData::taskId), (App)ItemStack.CODEC.optionalFieldOf("skin", (Object)ItemStack.EMPTY).forGetter(TaskScreenSaveData::skin), (App)Codec.BOOL.optionalFieldOf("indestructible", (Object)false).forGetter(TaskScreenSaveData::indestructible), (App)Codec.BOOL.optionalFieldOf("input_only", (Object)false).forGetter(TaskScreenSaveData::inputOnly), (App)ItemStack.CODEC.optionalFieldOf("skin", (Object)ItemStack.EMPTY).forGetter(TaskScreenSaveData::inputModeIcon), (App)Codec.BOOL.optionalFieldOf("text_shadow", (Object)false).forGetter(TaskScreenSaveData::textShadow)).apply((Applicative)builder, TaskScreenSaveData::new));
        public static StreamCodec<RegistryFriendlyByteBuf, TaskScreenSaveData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, TaskScreenSaveData::taskId, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, TaskScreenSaveData::skin, (StreamCodec)ByteBufCodecs.BOOL, TaskScreenSaveData::indestructible, (StreamCodec)ByteBufCodecs.BOOL, TaskScreenSaveData::inputOnly, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, TaskScreenSaveData::inputModeIcon, (StreamCodec)ByteBufCodecs.BOOL, TaskScreenSaveData::textShadow, TaskScreenSaveData::new);

        public static TaskScreenSaveData fromBlockEntity(TaskScreenBlockEntity b) {
            return new TaskScreenSaveData(b.taskId, b.skin, b.indestructible, b.inputOnly, b.inputModeIcon, b.textShadow);
        }
    }
}

