/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

public class FakeRenderingWorld
implements LevelAccessor {
    public final HashMap<BlockPos, BlockState> positions = new HashMap();
    private Level realWorld;
    private BlockPos lookingAt;

    public FakeRenderingWorld(Level rWorld, ArrayList<StatePos> coordinates, BlockPos lookingAt) {
        this.realWorld = rWorld;
        this.lookingAt = lookingAt;
        for (StatePos statePos : coordinates) {
            this.setBlock(statePos.pos, statePos.state, 0);
        }
        for (StatePos statePos : coordinates) {
            try {
                BlockState adjustedState = Block.updateFromNeighbourShapes((BlockState)statePos.state, (LevelAccessor)this, (BlockPos)statePos.pos);
                this.setBlock(statePos.pos, adjustedState, 0);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    @javax.annotation.Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockState blockState = this.getBlockState(pos);
        if (blockState.hasBlockEntity()) {
            BlockEntity blockEntity = ((EntityBlock)blockState.getBlock()).newBlockEntity(pos.offset((Vec3i)this.lookingAt), blockState);
            blockEntity.setLevel(this.realWorld);
            return blockEntity;
        }
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.positions.containsKey(pos) ? this.positions.get(pos) : this.realWorld.getBlockState(pos.offset((Vec3i)this.lookingAt));
    }

    public BlockState getBlockStateWithoutReal(BlockPos pos) {
        return this.positions.containsKey(pos) ? this.positions.get(pos) : Blocks.AIR.defaultBlockState();
    }

    public void scheduleTick(BlockPos p_186461_, Block p_186462_, int p_186463_) {
    }

    public boolean setBlock(BlockPos p_46944_, BlockState p_46945_, int p_46946_) {
        return this.setBlock(p_46944_, p_46945_, p_46946_, 512);
    }

    public boolean setBlock(BlockPos pos, BlockState state, int p_46949_, int p_46950_) {
        this.positions.put(pos, state);
        return true;
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public int getHeight() {
        return this.realWorld.getHeight();
    }

    public RegistryAccess registryAccess() {
        return null;
    }

    public FeatureFlagSet enabledFeatures() {
        return null;
    }

    @Nullable
    public ChunkAccess getChunk(int p_46823_, int p_46824_, ChunkStatus p_46825_, boolean p_46826_) {
        return null;
    }

    public int getHeight(Heightmap.Types p_46827_, int p_46828_, int p_46829_) {
        return 0;
    }

    public int getSkyDarken() {
        return 0;
    }

    public BiomeManager getBiomeManager() {
        return this.realWorld.getBiomeManager();
    }

    public Holder<Biome> getUncachedNoiseBiome(int p_204159_, int p_204160_, int p_204161_) {
        return null;
    }

    public boolean isClientSide() {
        return true;
    }

    public int getSeaLevel() {
        return 0;
    }

    public DimensionType dimensionType() {
        return this.realWorld.dimensionType();
    }

    public int getMinBuildHeight() {
        return this.realWorld.getMinBuildHeight();
    }

    public int getRawBrightness(BlockPos blockPos, int amount) {
        return this.realWorld.getRawBrightness(blockPos.offset((Vec3i)this.lookingAt), amount);
    }

    public boolean canSeeSky(BlockPos blockPos) {
        return this.realWorld.canSeeSky(blockPos.offset((Vec3i)this.lookingAt));
    }

    public long nextSubTickCount() {
        return 0L;
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelData getLevelData() {
        return this.realWorld.getLevelData();
    }

    public DifficultyInstance getCurrentDifficultyAt(BlockPos p_46800_) {
        return null;
    }

    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public ChunkSource getChunkSource() {
        return null;
    }

    public RandomSource getRandom() {
        return null;
    }

    public void playSound(@Nullable Player p_46775_, BlockPos p_46776_, SoundEvent p_46777_, SoundSource p_46778_, float p_46779_, float p_46780_) {
    }

    public void addParticle(ParticleOptions p_46783_, double p_46784_, double p_46785_, double p_46786_, double p_46787_, double p_46788_, double p_46789_) {
    }

    public void levelEvent(@Nullable Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
    }

    public void gameEvent(Holder<GameEvent> p_316267_, Vec3 p_220405_, GameEvent.Context p_220406_) {
    }

    public float getShade(Direction pDirection, boolean pShade) {
        ClientLevel clientLevel = (ClientLevel)this.realWorld;
        boolean flag = clientLevel.effects().constantAmbientLight();
        if (!pShade) {
            return flag ? 0.9f : 1.0f;
        }
        switch (pDirection) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public LevelLightEngine getLightEngine() {
        return Minecraft.getInstance().level.getLightEngine();
    }

    public WorldBorder getWorldBorder() {
        return null;
    }

    public List<Entity> getEntities(@Nullable Entity p_45936_, AABB p_45937_, Predicate<? super Entity> p_45938_) {
        return null;
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> p_151464_, AABB p_151465_, Predicate<? super T> p_151466_) {
        return null;
    }

    public List<? extends Player> players() {
        return null;
    }

    public boolean isStateAtPosition(BlockPos p_46938_, Predicate<BlockState> p_46939_) {
        return p_46939_.test(this.getBlockState(p_46938_));
    }

    public boolean isFluidAtPosition(BlockPos p_151584_, Predicate<FluidState> p_151585_) {
        return false;
    }

    public boolean removeBlock(BlockPos p_46951_, boolean p_46952_) {
        return false;
    }

    public boolean destroyBlock(BlockPos p_46957_, boolean p_46958_, @Nullable Entity p_46959_, int p_46960_) {
        return false;
    }
}

