/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.Styles;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GadgetBuilding
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.BUILDINGGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.BUILDINGGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (sneakPressed) {
            BaseMode mode = GadgetNBT.getMode(stack);
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.mode", (Object[])new Object[]{Component.translatable((String)mode.i18n())}).setStyle(Styles.AQUA));
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.range", (Object[])new Object[]{GadgetNBT.getToolRange(stack)}).setStyle(Styles.LT_PURPLE));
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.blockstate", (Object[])new Object[]{GadgetNBT.getGadgetBlockState(stack).getBlock().getName()}).setStyle(Styles.DK_GREEN));
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BlockState setState = GadgetNBT.getGadgetBlockState(gadget);
        if (setState.isAir()) {
            return InteractionResultHolder.pass((Object)gadget);
        }
        BaseMode mode = GadgetNBT.getMode(gadget);
        ArrayList<StatePos> buildList = mode.collect(context.hitResult().getDirection(), context.player(), GadgetBuilding.getHitPos(context), setState);
        UUID buildUUID = BuildingUtils.build(context.level(), context.player(), buildList, GadgetBuilding.getHitPos(context), gadget, true);
        GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
        GadgetNBT.clearAnchorPos(gadget);
        return InteractionResultHolder.success((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        BlockState blockState = context.level().getBlockState(context.pos());
        if (!GadgetUtils.isValidBlockState(blockState, context.level(), context.pos()) || blockState.getBlock() instanceof RenderBlock) {
            context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.invalidblock"), true);
            return super.onShiftAction(context);
        }
        if (GadgetUtils.setBlockState(context.stack(), blockState)) {
            return InteractionResultHolder.success((Object)context.stack());
        }
        return super.onShiftAction(context);
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.BUILDING;
    }
}

