/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.hats;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class HatData {
    private static final DateFormat fileDateFormat = new SimpleDateFormat("dd MM");
    private List<Events> events;
    private String username = "";

    public String isEventActive() {
        String hat = "";
        for (Events event : this.events) {
            boolean dayCheck;
            String date = fileDateFormat.format(new Date());
            String[] dateSplit = date.split(" ");
            int month = Integer.parseInt(dateSplit[1]);
            int day = Integer.parseInt(dateSplit[0]);
            boolean monthCheck = event.condition.date.month == 0 || month == event.condition.date.month;
            boolean bl = dayCheck = event.condition.date.day == 0 || day == event.condition.date.day;
            if (!monthCheck || !dayCheck) continue;
            hat = event.hat;
            this.username = event.condition.username;
        }
        return hat;
    }

    public String getUsername() {
        return this.username;
    }

    public static HatData getHatData(URL url) {
        try {
            String jsonString = IOUtils.toString((URL)url, (Charset)Charsets.UTF_8);
            return (HatData)new Gson().fromJson(jsonString, HatData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class Events {
        private String hat;
        private Condition condition;

        private Events(HatData hatData) {
        }

        private class Condition {
            private Date date;
            private String username;

            private Condition(Events events) {
            }

            private class Date {
                int month;
                int day;

                private Date(Condition condition) {
                }
            }
        }
    }
}

