/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.javd.block;

import com.unrealdinnerbone.javd.JAVDRegistry;
import com.unrealdinnerbone.javd.util.TelerportUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PortalBlock
extends Block
implements EntityBlock {
    public PortalBlock() {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.0f).sound(SoundType.STONE).mapColor(MapColor.COLOR_BLUE));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hand) {
        if (!level.isClientSide()) {
            boolean isInVoid = level.dimensionTypeRegistration().is(JAVDRegistry.Keys.DIMENSION_TYPE);
            TelerportUtils.teleport(player, isInVoid ? Level.OVERWORLD : JAVDRegistry.Keys.LEVEL, pos, !isInVoid);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)JAVDRegistry.PORTAL.get()).create(pos, state);
    }
}

