/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.oldwidget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.oldwidget.IWidget;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class ImageWidget
implements IWidget.Foreground {
    private final IWidget.Data _data = new IWidget.Data();
    private final ResourceLocation _imageSource;
    private int _color;

    public ImageWidget(BaseMenuUI<?> ui, ResourceLocation resource, float x, float y, float width, float height, int color) {
        this._data.Dimensions = new Rectangle(x, y, width, height);
        this._imageSource = resource;
        this._color = color;
    }

    public void setColor(int value) {
        this._color = value;
    }

    @Override
    @NotNull
    public IWidget.Data getData() {
        return this._data;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Vector4f rgba = ColorUtils.convertToRGBAVec(this._color);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this._imageSource);
        RenderSystem.setShaderColor((float)rgba.x(), (float)rgba.y(), (float)rgba.z(), (float)rgba.w());
        TiledIcon.innerBlit(graphics, 0.0f, this._data.Dimensions.width(), 0.0f, this._data.Dimensions.height(), 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        poseStack.popPose();
    }
}

