/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.datagen;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.datagen.BlockModelType;
import tv.soaryn.xycraft.core.datagen.ConnectedModelProvider;
import tv.soaryn.xycraft.core.datagen.CoreResources;

public abstract class BlockStateDataGen
extends BlockStateProvider {
    protected final String _modId;
    protected final ArrayList<BlockContent> registryCache;
    protected final ExistingFileHelper existingFileHelper;
    private static final String render_type = "cutout";

    public BlockStateDataGen(PackOutput output, ArrayList<BlockContent> registry, String modId, ExistingFileHelper exFileHelper) {
        super(output, modId, exFileHelper);
        this._modId = modId;
        this.registryCache = registry;
        this.existingFileHelper = exFileHelper;
        this.existingFileHelper.trackGenerated(CoreResources.CloudFX, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
    }

    protected void registerStatesAndModels() {
        this.registryCache.stream().filter(blockContent -> blockContent.getModelType() != BlockModelType.Custom).forEach(this::handleModel);
    }

    private void handleModel(BlockContent content) {
        switch (content.getModelType()) {
            case Simple: {
                this.simpleBlock(content.block(), this.cubeAll(content.block()));
                break;
            }
            case Special: {
                this.buildSpecialBlock(content);
                break;
            }
            case Connected: {
                this.buildConnectedBlock(content, this::cutout);
                break;
            }
            case Cloud: {
                this.buildCloudBlock(content);
                break;
            }
        }
    }

    protected void simple(ConnectedModelProvider<?> builder) {
    }

    protected void buildCloudPillar(BlockContent blockContent, BlockModelBuilder verticalModel, BlockModelBuilder horizontalModel) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockContent.block()).partialState().with((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false)).with(CoreStateProperties.Axis, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)verticalModel).addModel()).partialState().with((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false)).with(CoreStateProperties.Axis, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).addModel()).partialState().with((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false)).with(CoreStateProperties.Axis, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).rotationY(90).addModel()).partialState().with((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(true)).with(CoreStateProperties.Axis, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)verticalModel).addModel()).partialState().with((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(true)).with(CoreStateProperties.Axis, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).addModel()).partialState().with((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(true)).with(CoreStateProperties.Axis, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).rotationY(90).addModel();
    }

    protected BlockModelBuilder cloudOrientable(String modelPath, String parent) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, parent)).texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("side", CoreResources.CloudFX)).texture("top", CoreResources.CloudFX)).texture("bottom", CoreResources.CloudFX)).renderType(render_type);
        ModelBuilder.ElementBuilder elementCloud = model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        ModelBuilder.ElementBuilder elementPillar = model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        for (Direction direction : Direction.values()) {
            elementCloud = elementCloud.face(direction).texture("#cloud").emissivity(15, 15).cullface(direction).tintindex(0).ao(false).end();
            elementPillar = elementPillar.face(direction).texture(direction.getAxis() == Direction.Axis.Y ? (direction == Direction.UP ? "#top" : "#bottom") : "#side").rotation(direction == Direction.UP ? ModelBuilder.FaceRotation.UPSIDE_DOWN : ModelBuilder.FaceRotation.ZERO).cullface(direction).end();
        }
        return model;
    }

    protected BlockModelBuilder cloudModelPillar(String modelPath, String parent, BlockContent blockContent) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, parent)).texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("side", CoreResources.CloudFX)).texture("end", CoreResources.CloudFX)).renderType(render_type);
        ModelBuilder.ElementBuilder elementCloud = model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        ModelBuilder.ElementBuilder elementPillar = model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        for (Direction direction : Direction.values()) {
            ModelBuilder.ElementBuilder.FaceBuilder cloudFace = elementCloud.face(direction).texture("#cloud").emissivity(15, 15).cullface(direction).ao(false);
            int color = blockContent.getColor();
            if (color != -1) {
                cloudFace.color(color);
            } else {
                cloudFace.tintindex(0);
            }
            elementCloud = cloudFace.end();
            elementPillar = elementPillar.face(direction).texture(direction.getAxis() == Direction.Axis.Y ? "#end" : "#side").rotation(direction == Direction.UP ? ModelBuilder.FaceRotation.UPSIDE_DOWN : ModelBuilder.FaceRotation.ZERO).cullface(direction).end();
        }
        return model;
    }

    protected void cutout(ConnectedModelProvider<?> builder) {
        builder.end().renderType(render_type);
    }

    protected void translucent(ConnectedModelProvider<?> builder) {
        builder.end().renderType("translucent");
    }

    protected void buildConnectedBlock(BlockContent blockContent, String modelPath, String modelPathSingle, Consumer<ConnectedModelProvider<?>> builder) {
        ConnectedModelProvider model = (ConnectedModelProvider)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, "block/block")).texture("texture_single", modelPathSingle)).texture("texture_connected", modelPath)).customLoader(ConnectedModelProvider::new);
        builder.accept(model);
        this.simpleBlock(blockContent.block(), (ModelFile)model.end());
    }

    protected void buildConnectedBlock(BlockContent blockContent, Consumer<ConnectedModelProvider<?>> builder) {
        ConnectedModelProvider model = (ConnectedModelProvider)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockContent.modelPath(), "block/block")).texture("texture_single", this._modId + ":block/connected/" + blockContent.modelPath() + "_single")).texture("texture_connected", this._modId + ":block/connected/" + blockContent.modelPath())).customLoader(ConnectedModelProvider::new);
        builder.accept(model);
        this.simpleBlock(blockContent.block(), (ModelFile)model.end());
    }

    protected void buildSpecialBlock(BlockContent blockContent) {
        String texture = this._modId + ":block/" + blockContent.modelPath();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockContent.id().getPath(), "block/block")).texture("texture", texture)).texture("particle", texture);
        int emissivity = blockContent.getEmissivity();
        ModelBuilder.ElementBuilder element = model.element();
        element.textureAll("#texture");
        if (emissivity >= 0) {
            element.emissivity(emissivity, emissivity);
        }
        this.simpleBlock(blockContent.block(), (ModelFile)model);
    }

    protected void buildCloudBlock(BlockContent blockContent) {
        BlockModelBuilder model = (BlockModelBuilder)this.cloudModel(blockContent.id().getPath(), blockContent.getColor()).texture("tex", this._modId + ":block/" + blockContent.modelPath());
        this.simpleBlock(blockContent.block(), (ModelFile)model);
    }

    protected void buildCloudBlock(Iterable<BlockContent> wrappers) {
        wrappers.forEach(blockContent -> {
            BlockModelBuilder model = (BlockModelBuilder)this.cloudModel(blockContent.id().getPath(), blockContent.getColor()).texture("tex", this._modId + ":block/" + blockContent.modelPath());
            this.simpleBlock(blockContent.block(), (ModelFile)model);
        });
    }

    protected BlockModelBuilder cloudModel(String modelPath, int color) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().withExistingParent(modelPath, "block/block");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("tex", CoreResources.CloudFX)).renderType(render_type);
        if (model.getElementCount() == 0) {
            ModelBuilder.ElementBuilder t = model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).emissivity(15, 15).ao(false);
            t.color(color);
            for (Direction value : Direction.values()) {
                this.buildCloudFace(t, "#cloud", color, value);
            }
            ((BlockModelBuilder)t.end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#tex").cullface(Direction.DOWN).end().face(Direction.UP).texture("#tex").cullface(Direction.UP).end().face(Direction.NORTH).texture("#tex").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#tex").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#tex").cullface(Direction.WEST).end().face(Direction.EAST).texture("#tex").cullface(Direction.EAST).end();
        }
        return model;
    }

    private void buildCloudFace(ModelBuilder.ElementBuilder element, String tex, int color, Direction dir) {
        ModelBuilder.ElementBuilder.FaceBuilder face = element.face(dir).texture(tex).emissivity(15, 15).ao(false).cullface(dir);
        if (color == -1) {
            face.tintindex(0);
        } else {
            face.color(color);
        }
        face.end();
    }

    protected BlockModelBuilder cloudModelTintable(String modelPath, BlockContent blockContent) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, "block/block")).texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("tex", CoreResources.CloudFX)).renderType(render_type);
        ModelBuilder.ElementBuilder t = model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        for (Direction value : Direction.values()) {
            this.buildCloudFace(t, "#cloud", blockContent.getColor(), value);
        }
        t = model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        for (Direction value : Direction.values()) {
            this.buildCloudFace(t, "#tex", blockContent.getColor(), value);
        }
        return model;
    }
}

