/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.recipe;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.Tag;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;

public interface IRecipeBuilder<TBuilder, TRecipe extends Recipe<?>> {
    public static final Object2ObjectMap<String, String> RecipeNames = new Object2ObjectOpenHashMap();

    default public TBuilder seconds(long seconds) {
        return this.ticks(seconds * 20L);
    }

    @NotNull
    public TBuilder ticks(long var1);

    @NotNull
    public TRecipe makeRecipe();

    public void ensureValid(String var1);

    default public void save(@NotNull RecipeOutput output, @NotNull String id) {
        this.save(output, id, null);
    }

    default public void save(@NotNull RecipeOutput output, @NotNull String id, String displayName) {
        this.ensureValid(id);
        TRecipe recipe = this.makeRecipe();
        if (!(recipe instanceof IRecipeContent)) {
            throw new IllegalStateException("Recipe was not an IRecipeContent");
        }
        IRecipeContent r = (IRecipeContent)recipe;
        ResourceLocation loc = BuiltInRegistries.RECIPE_TYPE.getKey(r.getType());
        if (loc == null) {
            throw new IllegalStateException("Recipe Type was null - `" + id + "` -" + String.valueOf(r));
        }
        ResourceLocation recipeLoc = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"%s/%s".formatted(loc.getPath(), id));
        output.accept(recipeLoc, recipe, null);
        if (displayName != null) {
            RecipeNames.put((Object)Util.makeDescriptionId((String)"recipe", (ResourceLocation)recipeLoc), (Object)displayName);
        }
    }

    public static interface WithStage<TBuilder, TRecipe extends Recipe<?>>
    extends IRecipeBuilder<TBuilder, TRecipe> {
        default public TBuilder requires(Holder<IStage> stage) {
            return this.requires((IStage)stage.value());
        }

        @NotNull
        public TBuilder requires(IStage var1);
    }

    public static interface WithFluid {

        public static interface Output<TBuilder, TRecipe extends Recipe<?>>
        extends IRecipeBuilder<TBuilder, TRecipe> {
            default public TBuilder output(FluidContent content, int amount) {
                return this.output((Fluid)content.Source.get(), amount);
            }

            default public TBuilder output(Fluid input, int amount) {
                return this.output(new FluidStack(input, amount));
            }

            public TBuilder output(FluidStack var1);
        }

        public static interface Input<TBuilder, TRecipe extends Recipe<?>>
        extends IRecipeBuilder<TBuilder, TRecipe> {
            default public TBuilder input(FluidContent input, int amount) {
                return this.input((Fluid)input.Source.get(), amount);
            }

            default public TBuilder input(Fluid input, int amount) {
                return this.input(SizedFluidIngredient.of((Fluid)input, (int)amount));
            }

            default public TBuilder input(TagKey<Fluid> input, int amount) {
                return this.input(SizedFluidIngredient.of(input, (int)amount));
            }

            public TBuilder input(SizedFluidIngredient var1);
        }
    }

    public static interface WithItem {

        public static interface Output<TBuilder, TRecipe extends Recipe<?>>
        extends IRecipeBuilder<TBuilder, TRecipe> {
            default public TBuilder output(ItemLike item) {
                return this.output(item, 1);
            }

            default public TBuilder output(ItemLike item, int amount) {
                return this.output(new ItemStack(item, amount));
            }

            public TBuilder output(ItemStack var1);
        }

        public static interface Input<TBuilder, TRecipe extends Recipe<?>>
        extends IRecipeBuilder<TBuilder, TRecipe> {
            default public TBuilder input(Tag<Item> item) {
                return this.input(item.tag());
            }

            default public TBuilder input(TagKey<Item> item) {
                return this.input(SizedIngredient.of(item, (int)1));
            }

            default public TBuilder input(ItemLike item) {
                return this.input(item, 1);
            }

            default public TBuilder input(ItemLike item, int amount) {
                return this.input(SizedIngredient.of((ItemLike)item, (int)amount));
            }

            public TBuilder input(SizedIngredient var1);
        }
    }
}

