/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.items;

import net.minecraft.world.item.ItemStack;
import tv.soaryn.xycraft.api.content.capabilities.HandlerAction;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyHandler;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;

public record EnergyHandlerItemStack(ItemStack container) implements IXynergyHandler
{
    public int receiveEnergy(int amount, boolean action) {
        if (this.container.getCount() != 1 || amount <= 0) {
            return 0;
        }
        int stored = this.getEnergyStored();
        int capacity = this.getMaxEnergyStored();
        int remaining = capacity - stored;
        if (remaining <= 0) {
            return 0;
        }
        int fillAmount = Math.min(capacity - stored, amount);
        if (action == HandlerAction.Execute.Value) {
            this.container.set(CoreItemDataComponents.EnergyStored, (Object)(fillAmount + stored));
        }
        return fillAmount;
    }

    public int extractEnergy(int amount, boolean action) {
        if (this.container.getCount() != 1 || amount <= 0) {
            return 0;
        }
        int stored = this.getEnergyStored();
        if (stored <= 0) {
            return 0;
        }
        int drainAmount = Math.min(stored, amount);
        if (action == HandlerAction.Execute.Value) {
            this.container.set(CoreItemDataComponents.EnergyStored, (Object)(stored - drainAmount));
        }
        return drainAmount;
    }

    public int getEnergyStored() {
        return (Integer)this.container.getOrDefault(CoreItemDataComponents.EnergyStored, (Object)0);
    }

    public int getMaxEnergyStored() {
        return (Integer)this.container.getOrDefault(CoreItemDataComponents.EnergyCapacity, (Object)1);
    }
}

