/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import java.util.EnumMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.RegistrationContentBuilder;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.datagen.BlockModelType;

public class ColoredBlockContentRegistrationBuilder<TColor extends Enum<TColor> & IColorSource>
extends RegistrationContentBuilder<ColoredBlockContentRegistrationBuilder<TColor>, EnumMap<TColor, BlockContent>> {
    private Supplier<BlockBehaviour.Properties> _blockProperties = BlockBehaviour.Properties::of;
    private Supplier<Item.Properties> _itemProperties = Item.Properties::new;
    private final BiFunction<TColor, BlockBehaviour.Properties, Block> _blockFactory;
    private BiFunction<TColor, Block, Item> _itemBlockFactory = (color, block) -> new XyBlockItem((Block)block, this._itemProperties.get());
    private final Class<TColor> _class;
    private DeferredHolder<CreativeModeTab, CreativeModeTab> _tab;
    private BiConsumer<TColor, BlockContent> _contentConsumer = (tColor, blockContent) -> {};
    private BlockModelType _model = BlockModelType.Simple;

    public ColoredBlockContentRegistrationBuilder(ContentMap map, Class<TColor> c, String contentId, BiFunction<TColor, BlockBehaviour.Properties, Block> factory) {
        super(map, contentId);
        this._blockFactory = factory;
        this._class = c;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> withTab(@Nullable DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> withBlockProperties(Supplier<BlockBehaviour.Properties> properties) {
        this._blockProperties = properties;
        return this;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> copyPropertiesFrom(Supplier<Block> backingBlock) {
        this._blockProperties = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)backingBlock.get()));
        return this;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> withItemProperties(Supplier<Item.Properties> itemProperties) {
        this._itemProperties = itemProperties;
        return this;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> withItem(BiFunction<TColor, Block, Item> item) {
        this._itemBlockFactory = item;
        return this;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> withModelType(BlockModelType model) {
        this._model = model;
        return this;
    }

    public ColoredBlockContentRegistrationBuilder<TColor> withConsumer(BiConsumer<TColor, BlockContent> contentConsumer) {
        this._contentConsumer = contentConsumer;
        return this;
    }

    @Override
    public EnumMap<TColor, BlockContent> build() {
        return (EnumMap)Util.make(new EnumMap(this._class), map -> {
            for (Enum color : (Enum[])this._class.getEnumConstants()) {
                DeferredBlock registryBlock = this._map.BlockMap.register(this.Id + "_" + ((StringRepresentable)color).getSerializedName(), () -> this._blockFactory.apply(color, this._blockProperties.get()));
                DeferredItem registryItem = this._map.ItemMap.register(this.Id + "_" + ((StringRepresentable)color).getSerializedName(), () -> this._itemBlockFactory.apply(color, (Block)registryBlock.get()));
                BlockContent content = new BlockContent((DeferredBlock<Block>)registryBlock, (DeferredItem<Item>)registryItem);
                content.withModelPath(this.Id);
                content.withColor(((IColorSource)((Object)color)).getColor());
                this._localizations.forEach((mcLocale, name) -> content.withName(mcLocale.toString(), name.formatted(color.name())));
                content.withModelType(this._model);
                content.setTab((DeferredHolder)this._tab);
                content.requires(this._requirement);
                this._contentConsumer.accept(color, content);
                this._map.ListOfBlocks.add(content);
                this._map.MappedContent.add(content);
                map.put(color, content);
            }
        });
    }
}

