/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.utils.compat.ExternalMod;

public final class Tag<T> {
    public static ObjectList<Tag<?>> TagList = new ObjectArrayList();
    private final TagKey<T> _tag;
    private final Object2ObjectMap<String, String> _localization = new Object2ObjectOpenHashMap();

    public static <T> Tag<T> create(ResourceKey<? extends Registry<T>> key, ExternalMod owner, String name) {
        return Tag.create(TagKey.create(key, (ResourceLocation)owner.resource(name)));
    }

    public static <T> Tag<T> create(ResourceKey<? extends Registry<T>> key, ExternalMod owner, TagKey<T> base, String name) {
        return Tag.create(TagKey.create(key, (ResourceLocation)owner.resource("%s/%s".formatted(base.location().getPath(), name))));
    }

    public static <T> Tag<T> create(ResourceKey<? extends Registry<T>> key, String owner, String name) {
        return Tag.create(TagKey.create(key, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)owner, (String)name)));
    }

    public static <T> Tag<T> create(TagKey<T> tag) {
        return new Tag<T>(tag);
    }

    public static <T> EnumMap<XyCraftColors, Tag<T>> createColored(ResourceKey<? extends Registry<T>> registry, ExternalMod owner, String base) {
        return (EnumMap)Util.make(new EnumMap(XyCraftColors.class), map -> {
            for (XyCraftColors color : XyCraftColors.values()) {
                map.put(color, Tag.create(registry, owner, base + color.getSerializedName()).withName("XyCraft " + color.name()));
            }
        });
    }

    private Tag(TagKey<T> tag) {
        this._tag = tag;
        TagList.add((Object)this);
    }

    public Tag<T> withName(String locale, String localizedName) {
        this._localization.put((Object)locale, (Object)localizedName);
        return this;
    }

    @Nullable
    public String getName(String locale) {
        return (String)this._localization.get((Object)locale);
    }

    public Tag<T> withName(String localizedName) {
        return this.withName("en_us", localizedName);
    }

    public TagKey<T> tag() {
        return this._tag;
    }
}

