/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.pipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.ListenableGraph;
import org.jgrapht.graph.AsSubgraph;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;
import tv.soaryn.xycraft.api.content.pipes.IPipeGraphFactory;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeGraphState;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public record PipeNetwork<TGraph extends PipeGraph<TCap, TGraph>, TCap>(Object2ObjectOpenHashMap<UUID, TGraph> IdToGraph, Long2ObjectOpenHashMap<UUID> PosToId, Long2ObjectOpenHashMap<LongArraySet> ChunkToPos, IPipeGraphFactory<TGraph, TCap> graphFactory) {
    public static <TGraph extends PipeGraph<TCapability, TGraph>, TCapability> Codec<PipeNetwork<TGraph, TCapability>> codec(Codec<TGraph> graphCodec, IPipeGraphFactory<TGraph, TCapability> graphFactory) {
        return RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.tupleOf(UUIDUtil.CODEC, graphCodec, Object2ObjectOpenHashMap::new).fieldOf("id_to_graph").forGetter(PipeNetwork::IdToGraph), (App)CodecUtils.tupleOf(Codec.LONG, UUIDUtil.CODEC, Long2ObjectOpenHashMap::new).fieldOf("pos_to_id").forGetter(PipeNetwork::PosToId), (App)CodecUtils.tupleOf(Codec.LONG, NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).xmap(LongArraySet::new, LongArraySet::new), Long2ObjectOpenHashMap::new).fieldOf("chunk_to_pos").forGetter(PipeNetwork::ChunkToPos)).apply((Applicative)builder, (idToGraph, posToId, chunkToPos) -> new PipeNetwork(idToGraph, (Long2ObjectOpenHashMap<UUID>)posToId, (Long2ObjectOpenHashMap<LongArraySet>)chunkToPos, graphFactory)));
    }

    public static <TGraph extends PipeGraph<TCap, TGraph>, TCap> AttachmentType.Builder<PipeNetwork<TGraph, TCap>> builder(Codec<TGraph> graphCodec, IPipeGraphFactory<TGraph, TCap> graphFactory) {
        return AttachmentType.builder(() -> new PipeNetwork(new Object2ObjectOpenHashMap(), (Long2ObjectOpenHashMap<UUID>)new Long2ObjectOpenHashMap(), (Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(), graphFactory)).serialize(PipeNetwork.codec(graphCodec, graphFactory));
    }

    @Nullable
    public TGraph getPipeGraph(BlockPos pos) {
        return this.getPipeGraph(pos.asLong());
    }

    @Nullable
    public TGraph getPipeGraph(long posId) {
        UUID id = (UUID)this.PosToId.get(posId);
        if (id == null) {
            return null;
        }
        return (TGraph)((PipeGraph)this.IdToGraph.get((Object)id));
    }

    public void addPipe(ServerLevel level, BlockPos pos) {
        long posId = pos.asLong();
        TGraph graph = this.getPipeGraph(posId);
        if (graph != null) {
            return;
        }
        IPipeConnection cap = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, pos, null);
        if (cap == null) {
            XyCore.Logger.error("There is no capability at block position [%s]".formatted(pos.toShortString()));
            return;
        }
        HashSet<PipeGraph> graphs = new HashSet<PipeGraph>();
        for (Direction dir : Direction.values()) {
            PipeGraph g;
            BlockPos relative;
            long aLong;
            UUID id;
            if (cap.getLogic(dir) == PipeConnectionType.None || (id = (UUID)this.PosToId.get(aLong = (relative = pos.relative(dir)).asLong())) == null || (g = (PipeGraph)this.IdToGraph.get((Object)id)) == null) continue;
            graphs.add(g);
        }
        UUID uuid = UUID.randomUUID();
        PipeGraph newGraph = this.graphFactory.create(uuid);
        this.IdToGraph.put((Object)uuid, newGraph);
        PipeRoute route = newGraph.getRouteContainer();
        route.RouteGraph.addVertex((Object)posId);
        for (PipeGraph g : graphs) {
            ListenableGraph<Long, EdgeData> otherRouteGraph = g.getRouteContainer().RouteGraph;
            Graphs.addGraph(route.RouteGraph, otherRouteGraph);
            newGraph.copyDataFrom((PipeGraph)g);
            g.getRouteContainer().removeAllNodes();
            this.IdToGraph.remove((Object)g.id());
            g.onGraphRemove(level, g.id());
            g.setValid(PipeGraphState.INVALID);
        }
        Iterator iterator = route.RouteGraph.vertexSet().iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            this.PosToId.put(value, (Object)uuid);
            long chunkPosId = ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)value)), (int)SectionPos.blockToSectionCoord((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)value))));
            ((LongArraySet)this.ChunkToPos.computeIfAbsent(chunkPosId, o -> new LongArraySet())).add(value);
        }
        route.buildCaches(this, level, false);
        newGraph.rebuild(level);
        newGraph.onGraphForm(level, newGraph.id(), new LongArraySet(route.RouteGraph.vertexSet()), route.RouteGraph.edgeSet());
    }

    public void removePipe(ServerLevel level, long posId) {
        TGraph pipeGraph = this.getPipeGraph(posId);
        if (pipeGraph == null) {
            return;
        }
        UUID originalId = ((PipeGraph)pipeGraph).id();
        ((PipeGraph)pipeGraph).setValid(PipeGraphState.INVALID);
        PipeRoute pipeRoute = ((PipeGraph)pipeGraph).getRouteContainer();
        ((PipeGraph)pipeGraph).onPipeRemoved(level, posId);
        PipeNetwork.removeRoute(posId, pipeRoute);
        this.PosToId.remove(posId);
        this.removeFromChunkPosMapping(posId);
        if (pipeRoute.RouteGraph.vertexSet().isEmpty()) {
            this.IdToGraph.remove((Object)originalId);
            ((PipeGraph)pipeGraph).onGraphRemove(level, originalId);
            return;
        }
        if (pipeRoute.Inspector.isConnected()) {
            return;
        }
        this.splitUpGraph(level, pipeGraph, pipeRoute);
        this.IdToGraph.remove((Object)originalId);
    }

    private void removeFromChunkPosMapping(long posId) {
        long chunkId = SectionPos.blockToSection((long)posId);
        LongArraySet positions = (LongArraySet)this.ChunkToPos.get(chunkId);
        if (positions != null) {
            positions.remove(posId);
            if (positions.isEmpty()) {
                this.ChunkToPos.remove(chunkId);
            }
        }
    }

    private static <TCap> void removeRoute(long posId, PipeRoute<TCap> pipeRoute) {
        pipeRoute.PosToPipeConnectionCache.remove(posId);
        pipeRoute.PosToExternalCaches.remove(posId);
        pipeRoute.PosToValidExternalConnectionMap.remove(posId);
        pipeRoute.RouteGraph.removeVertex((Object)posId);
    }

    public void load(ServerLevel level) {
        for (PipeGraph graph : this.IdToGraph.values()) {
            graph.getRouteContainer().buildCaches(this, level, true);
            graph.rebuild(level);
        }
    }

    public void preTick(ServerLevel level) {
        for (PipeGraph g : this.IdToGraph.values()) {
            g.preTick_internal(level);
        }
    }

    public void postTick(ServerLevel level) {
        for (PipeGraph g : this.IdToGraph.values()) {
            g.postTick(level);
        }
    }

    public void clean(ServerLevel level) {
        PipeRoute route;
        ObjectArraySet wipedIds = new ObjectArraySet();
        List<PipeGraph> iterable = List.copyOf(this.IdToGraph.values());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (PipeGraph pipeGraph : iterable) {
            route = pipeGraph.getRouteContainer();
            if (!pipeGraph.IsLoaded || route.pipeChanges.isEmpty() || wipedIds.contains((Object)pipeGraph.id())) continue;
            LongArraySet pipeChangeSet = new LongArraySet(route.pipeChanges);
            boolean mutatedPipes = false;
            for (long pipePosId : pipeChangeSet.toLongArray()) {
                mutablePos.set(pipePosId);
                if (!level.shouldTickBlocksAt((BlockPos)mutablePos)) continue;
                this.cleanupPipeConnectionCache(pipeGraph, pipePosId, route, (ObjectArraySet<UUID>)wipedIds, level);
                mutatedPipes = true;
                route.pipeChanges.remove(pipePosId);
            }
            if (!mutatedPipes) continue;
            if (!route.Inspector.isConnected()) {
                UUID originalId = pipeGraph.id();
                this.splitUpGraph(level, pipeGraph, route);
                wipedIds.add((Object)originalId);
                continue;
            }
            Object object = route.RouteGraph.vertexSet().iterator();
            while (object.hasNext()) {
                long posId = (Long)object.next();
                this.PosToId.put(posId, (Object)pipeGraph.id());
            }
            this.IdToGraph.put((Object)pipeGraph.id(), (Object)pipeGraph);
            route.buildCaches(this, level, false);
            pipeGraph.rebuild(level);
            pipeGraph.onGraphForm(level, pipeGraph.id(), new LongArraySet(route.RouteGraph.vertexSet()), route.RouteGraph.edgeSet());
        }
        for (UUID wipedId : wipedIds) {
            PipeGraph pipeGraph = (PipeGraph)this.IdToGraph.remove((Object)wipedId);
            if (pipeGraph == null) continue;
            pipeGraph.onGraphRemove(level, pipeGraph.id());
        }
        for (PipeGraph pipeGraph : this.IdToGraph.values()) {
            route = pipeGraph.getRouteContainer();
            if (!pipeGraph.IsLoaded || route.handlerChanges.isEmpty()) continue;
            LongArraySet handlerChangeSet = new LongArraySet(route.handlerChanges);
            boolean hasChanged = false;
            for (long pipePosId : handlerChangeSet.toLongArray()) {
                mutablePos.set(pipePosId);
                if (!level.shouldTickBlocksAt((BlockPos)mutablePos)) continue;
                ObjectArraySet externals = (ObjectArraySet)route.PosToExternalCaches.get(pipePosId);
                if (externals == null) {
                    route.PosToValidExternalConnectionMap.remove(pipePosId);
                } else {
                    ObjectArraySet<Direction> directions = this.getDirections(externals);
                    route.PosToValidExternalConnectionMap.put(pipePosId, directions);
                }
                route.handlerChanges.remove(pipePosId);
                hasChanged = true;
            }
            if (!hasChanged) continue;
            route.buildCaches(this, level, false);
            pipeGraph.rebuild(level);
        }
    }

    @NotNull
    private ObjectArraySet<Direction> getDirections(ObjectArraySet<BlockCapabilityCache<TCap, Direction>> externals) {
        ObjectArraySet directions = new ObjectArraySet();
        for (BlockCapabilityCache external : externals) {
            boolean isPipe;
            if (external.getCapability() == null || (isPipe = this.PosToId.containsKey(external.pos().asLong()))) continue;
            directions.add((Object)((Direction)external.context()).getOpposite());
        }
        return directions;
    }

    private void cleanupPipeConnectionCache(TGraph pipeGraph, long pipePosId, PipeRoute<TCap> route, ObjectArraySet<UUID> wipedIds, ServerLevel level) {
        BlockCapabilityCache cache = (BlockCapabilityCache)route.PosToPipeConnectionCache.get(pipePosId);
        if (cache == null) {
            XyCore.Logger.error("We have a broken cache but how?");
            return;
        }
        IPipeConnection cap = (IPipeConnection)cache.getCapability();
        if (cap == null) {
            PipeNetwork.removeRoute(pipePosId, route);
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block6: for (Direction dir : Direction.values()) {
            PipeConnectionType otherLogic;
            pos.set(pipePosId);
            pos.move(dir);
            long otherId = pos.asLong();
            if (!level.shouldTickBlocksAt((BlockPos)pos)) continue;
            PipeConnectionType logic = cap.getLogic(dir);
            TGraph otherGraph = this.getPipeGraph(otherId);
            if (otherGraph == null || logic == PipeConnectionType.None || cap.isClosed(dir)) {
                route.RouteGraph.removeEdge((Object)pipePosId, (Object)otherId);
                route.RouteGraph.removeEdge((Object)otherId, (Object)pipePosId);
                continue;
            }
            BlockCapabilityCache otherCache = (BlockCapabilityCache)((PipeGraph)otherGraph).getRouteContainer().PosToPipeConnectionCache.get(otherId);
            if (otherCache == null) {
                XyCore.Logger.error("Capability Cache null at [%s]".formatted(BlockPos.of((long)otherId).toShortString()));
                continue;
            }
            PipeConnectionType commonLogic = logic;
            IPipeConnection otherCap = (IPipeConnection)otherCache.getCapability();
            otherCap = (IPipeConnection)otherCache.getCapability();
            PipeConnectionType pipeConnectionType = otherLogic = otherCap == null ? PipeConnectionType.None : otherCap.getLogic(dir.getOpposite());
            if (otherCap == null || otherCap.isClosed(dir.getOpposite()) || !((PipeGraph)pipeGraph).canMerge(otherGraph)) {
                route.RouteGraph.removeEdge((Object)pipePosId, (Object)otherId);
                route.RouteGraph.removeEdge((Object)otherId, (Object)pipePosId);
                continue;
            }
            if (otherLogic == PipeConnectionType.None) {
                route.RouteGraph.removeEdge((Object)pipePosId, (Object)otherId);
                route.RouteGraph.removeEdge((Object)otherId, (Object)pipePosId);
                continue;
            }
            if (otherLogic != PipeConnectionType.Transfer) {
                if (logic == PipeConnectionType.Transfer) {
                    commonLogic = otherLogic.reverse();
                } else if (logic == otherLogic) {
                    commonLogic = PipeConnectionType.None;
                }
            }
            if (otherGraph != pipeGraph) {
                ((PipeGraph)pipeGraph).copyDataFrom(otherGraph);
                route.Inspector.connectedSets();
                ((PipeGraph)otherGraph).getRouteContainer().Inspector.connectedSets();
                Graphs.addGraph(route.RouteGraph, ((PipeGraph)otherGraph).getRouteContainer().RouteGraph);
                ((PipeGraph)otherGraph).getRouteContainer().removeAllNodes();
                wipedIds.add((Object)((PipeGraph)otherGraph).id());
            }
            long capWeight = cap.weight();
            long otherWeight = otherCap.weight();
            switch (commonLogic) {
                case Transfer: {
                    route.RouteGraph.addEdge((Object)pipePosId, (Object)otherId, (Object)new EdgeData(pipePosId, otherId, capWeight));
                    route.RouteGraph.addEdge((Object)otherId, (Object)pipePosId, (Object)new EdgeData(otherId, pipePosId, otherWeight));
                    continue block6;
                }
                case Insert: {
                    route.RouteGraph.addEdge((Object)pipePosId, (Object)otherId, (Object)new EdgeData(pipePosId, otherId, capWeight));
                    route.RouteGraph.removeEdge((Object)otherId, (Object)pipePosId);
                    continue block6;
                }
                case Extract: {
                    route.RouteGraph.addEdge((Object)otherId, (Object)pipePosId, (Object)new EdgeData(otherId, pipePosId, otherWeight));
                    route.RouteGraph.removeEdge((Object)pipePosId, (Object)otherId);
                    continue block6;
                }
                case None: {
                    route.RouteGraph.removeEdge((Object)pipePosId, (Object)otherId);
                    route.RouteGraph.removeEdge((Object)otherId, (Object)pipePosId);
                }
            }
        }
    }

    private void splitUpGraph(ServerLevel level, TGraph pipeGraph, PipeRoute<TCap> route) {
        for (Set set : route.Inspector.connectedSets()) {
            UUID uuid = UUID.randomUUID();
            AsSubgraph subGraph = new AsSubgraph(route.RouteGraph, set);
            TGraph newGraph = this.graphFactory.create(uuid);
            PipeRoute newRoute = ((PipeGraph)newGraph).getRouteContainer();
            Graphs.addGraph(newRoute.RouteGraph, (Graph)subGraph);
            this.IdToGraph.put((Object)uuid, newGraph);
            ((PipeGraph)newGraph).copyDataFrom(pipeGraph);
            newRoute.buildCaches(this, level, false);
            ((PipeGraph)newGraph).rebuild(level);
            ((PipeGraph)newGraph).onGraphForm(level, ((PipeGraph)newGraph).id(), new LongArraySet(newRoute.RouteGraph.vertexSet()), newRoute.RouteGraph.edgeSet());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                this.PosToId.put(l, (Object)uuid);
            }
        }
        ((PipeGraph)pipeGraph).onGraphRemove(level, ((PipeGraph)pipeGraph).id());
        this.IdToGraph.remove((Object)((PipeGraph)pipeGraph).id());
        route.removeAllNodes();
    }
}

