/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.datagen.client;

import com.mrbysco.heads.registry.HeadReg;
import com.mrbysco.heads.registry.HeadsRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class HeadLanguageProvider
extends LanguageProvider {
    public HeadLanguageProvider(PackOutput packOutput) {
        super(packOutput, "heads", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.heads", "Heads");
        this.addHead(HeadsRegistry.AXOLOTL_BLUE, "Axolotl");
        this.addHead(HeadsRegistry.AXOLOTL_CYAN, "Axolotl");
        this.addHead(HeadsRegistry.AXOLOTL_GOLD, "Axolotl");
        this.addHead(HeadsRegistry.AXOLOTL_LUCY, "Axolotl");
        this.addHead(HeadsRegistry.AXOLOTL_WILD, "Axolotl");
        this.addHead(HeadsRegistry.BAT, "Bat");
        this.addHead(HeadsRegistry.BEE, "Bee");
        this.addHead(HeadsRegistry.BLAZE, "Blaze");
        this.addHead(HeadsRegistry.CAT_ALL_BLACK, "Cat");
        this.addHead(HeadsRegistry.CAT_BLACK, "Cat");
        this.addHead(HeadsRegistry.CAT_BRITISH_SHORTHAIR, "Cat");
        this.addHead(HeadsRegistry.CAT_CALICO, "Cat");
        this.addHead(HeadsRegistry.CAT_JELLIE, "Cat");
        this.addHead(HeadsRegistry.CAT_PERSIAN, "Cat");
        this.addHead(HeadsRegistry.CAT_RAGDOLL, "Cat");
        this.addHead(HeadsRegistry.CAT_RED, "Cat");
        this.addHead(HeadsRegistry.CAT_SIAMESE, "Cat");
        this.addHead(HeadsRegistry.CAT_TABBY, "Cat");
        this.addHead(HeadsRegistry.CAT_WHITE, "Cat");
        this.addHead(HeadsRegistry.CAVE_SPIDER, "Cave Spider");
        this.addHead(HeadsRegistry.CHICKEN, "Chicken");
        this.addHead(HeadsRegistry.COD, "Cod");
        this.addHead(HeadsRegistry.COW, "Cow");
        this.addHead(HeadsRegistry.DOLPHIN, "Dolphin");
        this.addHead(HeadsRegistry.DONKEY, "Donkey");
        this.addHead(HeadsRegistry.DROWNED, "Drowned");
        this.addHead(HeadsRegistry.ENDERMAN, "Enderman", " Skull");
        this.addHead(HeadsRegistry.ENDERMITE, "Endermite", " Skull");
        this.addHead(HeadsRegistry.EVOKER, "Evoker", " Skull");
        this.addHead(HeadsRegistry.FOX, "Fox", " Skull");
        this.addHead(HeadsRegistry.FOX_SNOW, "Fox", " Skull");
        this.addHead(HeadsRegistry.GHAST, "Ghast", " Skull");
        this.addHead(HeadsRegistry.GLOW_SQUID, "Glow Squid");
        this.addHead(HeadsRegistry.GOAT, "Goat");
        this.addHead(HeadsRegistry.HOGLIN, "Hoglin");
        this.addHead(HeadsRegistry.HORSE_BLACK, "Horse");
        this.addHead(HeadsRegistry.HORSE_BROWN, "Horse");
        this.addHead(HeadsRegistry.HORSE_CHESTNUT, "Horse");
        this.addHead(HeadsRegistry.HORSE_CREAMY, "Horse");
        this.addHead(HeadsRegistry.HORSE_DARKBROWN, "Horse");
        this.addHead(HeadsRegistry.HORSE_GRAY, "Horse");
        this.addHead(HeadsRegistry.HORSE_SKELETON, "Skeleton Horse");
        this.addHead(HeadsRegistry.HORSE_UNDEAD, "Undead Horse");
        this.addHead(HeadsRegistry.HORSE_WHITE, "Horse");
        this.addHead(HeadsRegistry.HUSK, "Husk");
        this.addHead(HeadsRegistry.ILLUSIONER, "Illusioner");
        this.addHead(HeadsRegistry.IRON_GOLEM, "Iron Golem");
        this.addHead(HeadsRegistry.MAGMA_CUBE, "Magma Cube", "");
        this.addHead(HeadsRegistry.MULE, "Mule");
        this.addHead(HeadsRegistry.MOOSHROOM_BROWN, "Brown Mooshroom");
        this.addHead(HeadsRegistry.MOOSHROOM_RED, "Red Mooshroom");
        this.addHead(HeadsRegistry.OCELOT, "Ocelot");
        this.addHead(HeadsRegistry.PIG, "Pig");
        this.addHead(HeadsRegistry.PIGLIN, "Piglin");
        this.addHead(HeadsRegistry.PIGLIN_BRUTE, "Piglin Brute");
        this.addHead(HeadsRegistry.PILLAGER, "Pillager");
        this.addHead(HeadsRegistry.SALMON, "Salmon");
        this.addHead(HeadsRegistry.SHEEP_BLACK, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_BLUE, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_BROWN, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_CYAN, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_GRAY, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_GREEN, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_LIGHT_BLUE, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_LIGHT_GRAY, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_LIME, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_MAGENTA, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_ORANGE, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_PINK, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_PURPLE, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_RED, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_SHAVEN, "Sheep", " Head (Shaven)");
        this.addHead(HeadsRegistry.SHEEP_WHITE, "Sheep");
        this.addHead(HeadsRegistry.SHEEP_YELLOW, "Sheep");
        this.addHead(HeadsRegistry.SILVERFISH, "Silverfish", "");
        this.addHead(HeadsRegistry.SLIME, "Slime", "");
        this.addHead(HeadsRegistry.SNOW_GOLEM, "Snow Golem");
        this.addHead(HeadsRegistry.SPIDER, "Spider");
        this.addHead(HeadsRegistry.SQUID, "Squid");
        this.addHead(HeadsRegistry.STRAY, "Stray");
        this.addHead(HeadsRegistry.TURTLE, "Turtle");
        this.addHead(HeadsRegistry.VILLAGER, "Villager");
        this.addHead(HeadsRegistry.VINDICATOR, "Vindicator");
        this.addHead(HeadsRegistry.WANDERING_TRADER, "Wandering Trader");
        this.addHead(HeadsRegistry.WITCH, "Witch");
        this.addHead(HeadsRegistry.WOLF, "Wolf");
        this.addHead(HeadsRegistry.ZOGLIN, "Zoglin");
        this.addHead(HeadsRegistry.ZOMBIE_VILLAGER, "Zombie Villager");
        this.addHead(HeadsRegistry.ZOMBIFIED_PIGLIN, "Zombified Piglin", " Skull");
        this.addConfig("title", "Heads Config", null);
        this.addMobConfig("axolotl", "Axolotl");
        this.addMobConfig("bat", "Bat");
        this.addMobConfig("bee", "Bee");
        this.addMobConfig("blaze", "Blaze");
        this.addMobConfig("cat", "Cat");
        this.addMobConfig("caveSpider", "Cave Spider");
        this.addMobConfig("chicken", "Chicken");
        this.addMobConfig("cod", "Cod");
        this.addMobConfig("cow", "Cow");
        this.addMobConfig("dolphin", "Dolphin");
        this.addMobConfig("donkey", "Donkey");
        this.addMobConfig("drowned", "Drowned");
        this.addMobConfig("enderman", "Enderman");
        this.addMobConfig("endermite", "Endermite");
        this.addMobConfig("evoker", "Evoker");
        this.addMobConfig("fox", "Fox");
        this.addMobConfig("ghast", "Ghast");
        this.addMobConfig("glowSquid", "Glow Squid");
        this.addMobConfig("goat", "Goat");
        this.addMobConfig("hoglin", "Hoglin");
        this.addMobConfig("horse", "Horse");
        this.addMobConfig("skeletonHorse", "Skeleton Horse");
        this.addMobConfig("undeadHorse", "Undead Horse");
        this.addMobConfig("husk", "Husk");
        this.addMobConfig("illusioner", "Illusioner");
        this.addMobConfig("ironGolem", "Iron Golem");
        this.addMobConfig("magmaCube", "Magma Cube");
        this.addMobConfig("mule", "Mule");
        this.addMobConfig("mooshroom", "Mooshroom");
        this.addMobConfig("ocelot", "Ocelot");
        this.addMobConfig("pig", "Pig");
        this.addMobConfig("piglin", "Piglin");
        this.addMobConfig("piglinBrute", "Piglin Brute");
        this.addMobConfig("pillager", "Pillager");
        this.addMobConfig("salmon", "Salmon");
        this.addMobConfig("sheep", "Sheep");
        this.addMobConfig("silverfish", "Silverfish");
        this.addMobConfig("slime", "Slime");
        this.addMobConfig("snowGolem", "Snow Golem");
        this.addMobConfig("spider", "Spider");
        this.addMobConfig("squid", "Squid");
        this.addMobConfig("stray", "Stray");
        this.addMobConfig("turtle", "Turtle");
        this.addMobConfig("villager", "Villager");
        this.addMobConfig("vindicator", "Vindicator");
        this.addMobConfig("wanderingTrader", "Wandering Trader");
        this.addMobConfig("witch", "Witch");
        this.addMobConfig("wolf", "Wolf");
        this.addMobConfig("zoglin", "Zoglin");
        this.addMobConfig("zombieVillager", "Zombie Villager");
        this.addMobConfig("zombifiedPiglin", "Zombified Piglin");
    }

    private void addHead(HeadReg headReg, @Nullable String mobName) {
        this.addHead(headReg, mobName, null);
    }

    private void addHead(HeadReg headReg, String mobName, @Nullable String customSuffix) {
        String suffix = customSuffix == null ? " Head" : customSuffix;
        this.addBlock((Supplier)headReg.getHead(), mobName + suffix);
    }

    private void addMobConfig(String mobPath, String mobName) {
        this.addConfig(mobPath, mobName, mobName + " Settings");
        this.addConfig(mobPath + "EnableCreeperDrop", "Enable " + mobName + " Creeper drop", "Enable charged creeper explosion to drop a " + mobName + " head");
        this.addConfig(mobPath + "DropRate", mobName + " Drop Rate", "Defines the drop rate for the " + mobName + " head (0 to disable) [Default: 0.025]");
    }

    public void addSubtitle(Supplier<SoundEvent> sound, String text) {
        this.addSubtitle(sound.get(), text);
    }

    public void addSubtitle(SoundEvent sound, String text) {
        String path = "heads.subtitle." + sound.getLocation().getPath();
        this.add(path, text);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("heads.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("heads.configuration." + path + ".tooltip", description);
        }
    }
}

