/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.heads.client.models.SheepSkullFurModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SheepSkullModel
extends SkullModelBase {
    private final ModelPart root;
    protected final ModelPart head;
    protected final SheepSkullFurModel furModel;

    public SheepSkullModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.furModel = null;
    }

    public SheepSkullModel(ModelPart root, SheepSkullFurModel furModel) {
        this.root = root;
        this.head = root.getChild("head");
        this.furModel = furModel;
    }

    public static MeshDefinition createSheepHead() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -4.0f, 6.0f, 6.0f, 8.0f), PartPose.ZERO);
        return meshdefinition;
    }

    public static LayerDefinition createSkullModel() {
        MeshDefinition meshdefinition = SheepSkullModel.createSheepHead();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(float mouthAnimation, float yRot, float xRot) {
        this.head.yRot = yRot * ((float)Math.PI / 180);
        this.head.xRot = xRot * ((float)Math.PI / 180);
        if (this.furModel != null) {
            this.furModel.setupAnim(mouthAnimation, yRot, xRot);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        this.root.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        if (this.furModel != null) {
            this.furModel.renderToBuffer(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        }
    }
}

