/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.fluid;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.polylib.PolyLibPlatform;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandlerItem;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface FluidManager {
    public static final long BUCKET = FluidStack.bucketAmount();
    public static final long MILLIBUCKET = BUCKET / 1000L;

    default public long convert(long milliBuckets) {
        return milliBuckets * MILLIBUCKET;
    }

    @Nullable
    public PolyFluidHandler getBlockFluidHandler(BlockEntity var1, @Nullable Direction var2);

    @Nullable
    public PolyFluidHandlerItem getItemFluidHandler(ItemStack var1);

    public static PolyFluidHandler getHandler(BlockEntity tile, @Nullable Direction side) {
        return PolyLibPlatform.getFluidManager().getBlockFluidHandler(tile, side);
    }

    public static PolyFluidHandlerItem getHandler(ItemStack stack) {
        return PolyLibPlatform.getFluidManager().getItemFluidHandler(stack);
    }

    public static long insertFluid(BlockEntity tile, FluidStack fluidStack, Direction side, boolean simulate) {
        PolyFluidHandler handler = FluidManager.getHandler(tile, side);
        if (handler == null) {
            return 0L;
        }
        return handler.fill(fluidStack, simulate);
    }

    public static FluidStack extractFluid(BlockEntity tile, FluidStack fluidStack, Direction side, boolean simulate) {
        PolyFluidHandler handler = FluidManager.getHandler(tile, side);
        if (handler == null) {
            return FluidStack.empty();
        }
        return handler.drain(fluidStack, simulate);
    }

    public static FluidStack transferFluid(@Nullable PolyFluidHandler source, @Nullable PolyFluidHandler target) {
        if (source == null || target == null) {
            return FluidStack.empty();
        }
        FluidStack available = source.drain(Integer.MAX_VALUE, true);
        if (available.isEmpty()) {
            return FluidStack.empty();
        }
        long canFill = target.fill(available, true);
        if (canFill <= 0L) {
            return FluidStack.empty();
        }
        FluidStack canDrain = source.drain(canFill, true);
        if (canDrain.isEmpty()) {
            return FluidStack.empty();
        }
        if (canDrain.getAmount() != target.fill(canDrain, true)) {
            return FluidStack.empty();
        }
        return source.drain(target.fill(canDrain, false), false);
    }

    public static FluidStack transferFluid(BlockEntity source, Direction sourceSide, @Nullable PolyFluidHandler target) {
        PolyFluidHandler sourceHandler = FluidManager.getHandler(source, sourceSide);
        return FluidManager.transferFluid(sourceHandler, target);
    }

    public static FluidStack transferFluid(@Nullable PolyFluidHandler source, BlockEntity target, Direction targetSide) {
        PolyFluidHandler targetHandler = FluidManager.getHandler(target, targetSide);
        return FluidManager.transferFluid(source, targetHandler);
    }

    public static FluidStack transferFluid(BlockEntity source, Direction sourceSide, BlockEntity target, Direction targetSide) {
        PolyFluidHandler sourceHandler = FluidManager.getHandler(source, sourceSide);
        PolyFluidHandler targetHandler = FluidManager.getHandler(target, targetSide);
        return FluidManager.transferFluid(sourceHandler, targetHandler);
    }

    public static long transferFluid(FluidStack fluidStack, PolyFluidHandler source, PolyFluidHandler target) {
        long canFill = target.fill(fluidStack, true);
        return target.fill(source.drain(fluidStack.copyWithAmount(canFill), false), false);
    }

    public static long transferFluid(FluidStack fluidStack, BlockEntity source, Direction sourceSide, PolyFluidHandler target) {
        PolyFluidHandler handler = FluidManager.getHandler(source, sourceSide);
        return handler == null ? 0L : FluidManager.transferFluid(fluidStack, handler, target);
    }

    public static long transferFluid(FluidStack fluidStack, PolyFluidHandler source, BlockEntity target, Direction targetSide) {
        PolyFluidHandler handler = FluidManager.getHandler(target, targetSide);
        return handler == null ? 0L : FluidManager.transferFluid(fluidStack, source, handler);
    }

    public static long transferFluid(FluidStack fluidStack, BlockEntity source, Direction sourceSide, BlockEntity target, Direction targetSide) {
        PolyFluidHandler sourceStorage = FluidManager.getHandler(source, sourceSide);
        if (sourceStorage == null) {
            return 0L;
        }
        PolyFluidHandler targetHandler = FluidManager.getHandler(target, targetSide);
        return targetHandler == null ? 0L : FluidManager.transferFluid(fluidStack, sourceStorage, targetHandler);
    }

    public static boolean isFluidItem(ItemStack stack) {
        return FluidManager.getHandler(stack) != null;
    }

    public static boolean isFluidBlock(BlockEntity tile, @Nullable Direction side) {
        return FluidManager.getHandler(tile, side) != null;
    }
}

