/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.helpers;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PlayerHelper {
    public static boolean doesPlayerHaveItemEquipped(Player player, Item item) {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = player.getInventory().getArmor(i);
            if (stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerWearingEquipment(Player player, EquipmentSlot equipmentSlot) {
        return !player.getInventory().getArmor(equipmentSlot.getIndex()).isEmpty();
    }

    public static void giveItemStackToPlayer(Player player, ItemStack itemStack) {
        if (player == null) {
            return;
        }
        if (itemStack.isEmpty()) {
            return;
        }
        if (player.level() == null) {
            return;
        }
        boolean added = player.addItem(itemStack);
        if (!added) {
            Level level = player.level();
            ItemEntity itemEntity = new ItemEntity(level, (double)player.blockPosition().getX(), (double)player.blockPosition().getY(), (double)player.blockPosition().getZ(), itemStack);
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

