/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class FluidData
extends AbstractDataStore<FluidStack> {
    public FluidData() {
        super(FluidStack.empty());
    }

    public FluidData(FluidStack defaultValue) {
        super(defaultValue);
    }

    @Override
    public FluidStack set(FluidStack value) {
        if (!Objects.equals(value, this.value) && this.validator.test(value)) {
            this.value = value.copy();
            this.markDirty();
        }
        return (FluidStack)this.value;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(!((FluidStack)this.value).isEmpty());
        if (!((FluidStack)this.value).isEmpty()) {
            ((FluidStack)this.value).write(buf);
        }
    }

    @Override
    public void fromBytes(RegistryFriendlyByteBuf buf) {
        this.value = buf.readBoolean() ? this.validValue(FluidStack.read((RegistryFriendlyByteBuf)buf), (FluidStack)this.value) : FluidStack.empty();
    }

    @Override
    public Tag toTag(HolderLookup.Provider provider) {
        return ((FluidStack)this.value).isEmpty() ? new CompoundTag() : ((FluidStack)this.value).write(provider, (Tag)new CompoundTag());
    }

    @Override
    public void fromTag(HolderLookup.Provider provider, Tag tag) {
        CompoundTag cTag;
        FluidStack newStack = tag instanceof CompoundTag && (cTag = (CompoundTag)tag).isEmpty() ? FluidStack.empty() : FluidStack.read((HolderLookup.Provider)provider, (Tag)tag).orElse(FluidStack.empty());
        this.value = this.validValue(newStack, (FluidStack)this.value);
    }

    @Override
    public boolean isSameValue(FluidStack newValue) {
        return ((FluidStack)this.value).equals((Object)newValue);
    }
}

