/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal;

import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.RuinedPortalDecoratorBase;
import dev.orderedchaos.projectvibrantjourneys.core.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.jetbrains.annotations.Nullable;

public class BasaltDeltasRuinedPortalDecorator
extends RuinedPortalDecoratorBase {
    public BasaltDeltasRuinedPortalDecorator() {
        super("basalt_deltas_ruined_portal_decorator");
    }

    @Override
    @Nullable
    public BlockState getTopSoil(WorldGenLevel level, RandomSource random) {
        float oreChance = random.nextFloat();
        if (oreChance < 0.45f) {
            return Blocks.BASALT.defaultBlockState();
        }
        if (oreChance < 0.9f) {
            return Blocks.BLACKSTONE.defaultBlockState();
        }
        return Blocks.MAGMA_BLOCK.defaultBlockState();
    }

    @Override
    @Nullable
    public BlockState getFillerSoil(WorldGenLevel level, RandomSource random) {
        return Blocks.BASALT.defaultBlockState();
    }

    @Override
    public void decorate(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos groundPos) {
        float chance = random.nextFloat();
        if (chance < 0.8f && level.getBlockState(groundPos).is(Blocks.BASALT)) {
            BlockPos pos;
            int height = 1 + random.nextInt(4);
            for (int i = 1; i <= height && LevelUtils.isEmptyOrReplaceable((ServerLevelAccessor)level, pos = groundPos.above(i)); ++i) {
                level.setBlock(pos, Blocks.BASALT.defaultBlockState(), 2);
            }
        }
    }
}

