/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.material.Fluids;

public class RocksGroundcoverFeature
extends Feature<RandomPatchConfiguration> {
    public RocksGroundcoverFeature(Codec<RandomPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RandomPatchConfiguration> context) {
        RandomSource randomSource = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        BlockState originState = level.getBlockState(origin);
        if (!originState.canBeReplaced()) {
            return false;
        }
        BlockState ground = level.getBlockState(origin.below());
        if (ground.is(Blocks.SCULK) || ground.is(Blocks.DEEPSLATE) || ground.is(Blocks.AMETHYST_BLOCK)) {
            return false;
        }
        BlockState rocks = this.getRocksToPlace(randomSource, originState, origin, ground.getBlock());
        if (!rocks.canSurvive((LevelReader)level, origin)) {
            return false;
        }
        return level.setBlock(origin, rocks, 2);
    }

    private BlockState getRocksToPlace(RandomSource randomSource, BlockState originState, BlockPos origin, Block ground) {
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(randomSource);
        int model = randomSource.nextInt(5);
        BlockState rocks = ((Block)PVJBlocks.ROCKS.get()).defaultBlockState();
        if (ground == Blocks.RED_SAND || ground == Blocks.RED_SANDSTONE) {
            rocks = ((Block)PVJBlocks.RED_SANDSTONE_ROCKS.get()).defaultBlockState();
        } else if (ground == Blocks.SAND || ground == Blocks.SANDSTONE) {
            rocks = ((Block)PVJBlocks.SANDSTONE_ROCKS.get()).defaultBlockState();
        } else if (randomSource.nextFloat() < 0.2f && origin.getY() > 8) {
            rocks = ((Block)PVJBlocks.MOSSY_ROCKS.get()).defaultBlockState();
        }
        rocks = (BlockState)((BlockState)rocks.setValue((Property)GroundcoverBlock.FACING, (Comparable)dir)).setValue((Property)GroundcoverBlock.MODEL, (Comparable)Integer.valueOf(model));
        if (originState.getFluidState().getType() == Fluids.WATER) {
            rocks = (BlockState)rocks.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return rocks;
    }
}

