/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items;

import de.maxhenkel.easypiglins.Main;
import de.maxhenkel.easypiglins.corelib.client.CustomRendererItem;
import de.maxhenkel.easypiglins.corelib.client.ItemRenderer;
import de.maxhenkel.easypiglins.datacomponents.PiglinData;
import de.maxhenkel.easypiglins.items.render.PiglinItemRenderer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PiglinItem
extends CustomRendererItem {
    private String translationKey = EntityType.PIGLIN.getDescriptionId();

    public PiglinItem() {
        super(new Item.Properties().stacksTo(1));
        DispenserBlock.registerBehavior((ItemLike)this, (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos blockpos = source.pos().relative(direction);
            ServerLevel world = source.level();
            Piglin piglin = PiglinData.createPiglin(stack, (Level)world);
            piglin.absMoveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, direction.toYRot(), 0.0f);
            world.addFreshEntity((Entity)piglin);
            stack.shrink(1);
            return stack;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemRenderer createItemRenderer() {
        return new PiglinItemRenderer();
    }

    protected String getOrCreateDescriptionId() {
        return this.translationKey;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = world.getBlockState(blockpos);
        if (!blockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty()) {
            blockpos = blockpos.relative(direction);
        }
        Piglin piglin = PiglinData.createPiglin(itemstack, world);
        piglin.setPos((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5);
        if (world.addFreshEntity((Entity)piglin)) {
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack stack) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return super.getName(stack);
        }
        return PiglinData.getCachePiglin(stack, (Level)world).getDisplayName();
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player) || world.isClientSide) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.piglinInventorySounds.get()).booleanValue()) {
            return;
        }
        if (world.getGameTime() % 20L != 0L) {
            return;
        }
        if (world.random.nextInt(20) == 0) {
            Player playerEntity = (Player)entity;
            playerEntity.playNotifySound(SoundEvents.PIGLIN_AMBIENT, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }
}

