/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.mixins.compat;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.blockentity.storage.DriveBlockEntity;
import com.glodblock.github.extendedae.common.tileentities.TileExIOPort;
import com.sts15.enderdrives.items.EnderDiskItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileExIOPort.class}, remap=false)
public abstract class TileExIOPortMixin {
    @Unique
    private long enderdrives$ExLastSoundTick = 0L;
    @Unique
    private long enderdrives$ExLastMessageTick = 0L;

    @Inject(method={"tickingRequest"}, at={@At(value="HEAD")}, cancellable=true)
    private void enderdrives$ExPreventSameFrequencyTransfer(IGridNode node, int ticksSinceLastCall, CallbackInfoReturnable<TickRateModulation> cir) {
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        Level level = ((TileExIOPort)this).getLevel();
        if (level == null || level.isClientSide) {
            return;
        }
        BlockPos pos = ((TileExIOPort)this).getBlockPos();
        for (DriveBlockEntity drive : grid.getMachines(DriveBlockEntity.class)) {
            for (int j = 0; j < drive.getCellCount(); ++j) {
                int i;
                ItemStack driveStack = drive.getInternalInventory().getStackInSlot(j);
                if (!(driveStack.getItem() instanceof EnderDiskItem)) continue;
                int driveFreq = EnderDiskItem.getFrequency(driveStack);
                String driveScope = EnderDiskItem.getSafeScopePrefix(driveStack);
                for (i = 0; i < 6; ++i) {
                    ItemStack inputStack = ((TileExIOPort)this).getInternalInventory().getStackInSlot(i);
                    if (!(inputStack.getItem() instanceof EnderDiskItem)) continue;
                    int inputFreq = EnderDiskItem.getFrequency(inputStack);
                    String inputScope = EnderDiskItem.getSafeScopePrefix(inputStack);
                    if (inputFreq != driveFreq || !inputScope.equals(driveScope)) continue;
                    this.enderdrives$ExPlayLoopWarning(level, pos);
                    cir.setReturnValue((Object)TickRateModulation.IDLE);
                    return;
                }
                for (i = 6; i < 12; ++i) {
                    ItemStack outputStack = ((TileExIOPort)this).getInternalInventory().getStackInSlot(i);
                    if (!(outputStack.getItem() instanceof EnderDiskItem)) continue;
                    int outputFreq = EnderDiskItem.getFrequency(outputStack);
                    String outputScope = EnderDiskItem.getSafeScopePrefix(outputStack);
                    if (outputFreq != driveFreq || !outputScope.equals(driveScope)) continue;
                    this.enderdrives$ExPlayLoopWarning(level, pos);
                    cir.setReturnValue((Object)TickRateModulation.IDLE);
                    return;
                }
            }
        }
    }

    @Unique
    private void enderdrives$ExPlayLoopWarning(Level level, BlockPos pos) {
        long gameTime = level.getGameTime();
        if (gameTime - this.enderdrives$ExLastSoundTick >= 60L) {
            level.playSound(null, pos, SoundEvents.ENDERMAN_STARE, SoundSource.BLOCKS, 0.6f, 0.6f + level.random.nextFloat() * 0.4f);
            this.enderdrives$ExLastSoundTick = gameTime;
        }
        if (gameTime - this.enderdrives$ExLastMessageTick >= 100L) {
            this.enderdrives$ExLastMessageTick = gameTime;
            Player nearestPlayer = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0, false);
            if (nearestPlayer != null) {
                nearestPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a75[EnderDrives] Transfer blocked: Infinite loop detected between linked drives."));
            }
        }
    }
}

