/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import com.sts15.enderdrives.db.StoredEntry;
import com.sts15.enderdrives.db.TapeDBManager;
import com.sts15.enderdrives.db.TapeKey;
import com.sts15.enderdrives.integration.DriveBlockEntityAccessor;
import com.sts15.enderdrives.items.TapeDiskItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TapeDiskInventory
implements StorageCell {
    private static final Logger LOGGER = LogManager.getLogger((String)"EnderDrives");
    public static final ICellHandler HANDLER = new Handler();
    private final boolean disabled;
    private final ItemStack stack;
    private final UUID tapeId;
    private final int typeLimit;
    private static final ConcurrentMap<UUID, Object> DISK_LOCKS = new ConcurrentHashMap<UUID, Object>();

    public TapeDiskInventory(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof TapeDiskItem)) {
            throw new IllegalArgumentException("Not a TapeDisk.");
        }
        TapeDiskItem item2 = (TapeDiskItem)item;
        this.stack = stack;
        this.tapeId = TapeDiskItem.getOrCreateTapeId(stack);
        this.typeLimit = item2.getTypeLimit(stack);
        this.disabled = TapeDiskItem.isDisabled(stack);
    }

    public CellState getStatus() {
        TapeDBManager.TapeDriveCache cache = TapeDBManager.getCacheSafe(this.tapeId);
        if (cache == null) {
            return CellState.EMPTY;
        }
        int types = cache.entries.size();
        return types == 0 ? CellState.EMPTY : (types >= this.typeLimit ? CellState.FULL : ((float)types >= (float)this.typeLimit * 0.75f ? CellState.TYPES_FULL : CellState.NOT_EMPTY));
    }

    public double getIdleDrain() {
        if (this.disabled) {
            return 0.0;
        }
        TapeDBManager.TapeDriveCache cache = TapeDBManager.getCacheSafe(this.tapeId);
        int totalItems = cache != null ? cache.entries.size() : 0;
        return 5.0 + Math.log10(Math.max(1, totalItems + 1)) * 0.25;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.disabled || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey itemKey = (AEItemKey)what;
        if (!this.passesFilter((AEKey)itemKey)) {
            return 0L;
        }
        try {
            if (amount < 1L || amount > 99L) {
                return 0L;
            }
            ItemStack descriptorStack = itemKey.toStack(1);
            if (!this.isSpecialItem(descriptorStack) || !this.hasMeaningfulNBT(descriptorStack)) {
                return 0L;
            }
            byte[] data = TapeDiskItem.serializeItemStackToBytes(descriptorStack);
            if (data == null || data.length == 0) {
                return 0L;
            }
            Object object = TapeDiskInventory.getDiskLock(this.tapeId);
            synchronized (object) {
                long currentBytes;
                TapeDBManager.TapeDriveCache cache;
                try {
                    cache = TapeDBManager.getCacheSafe(this.tapeId);
                    if (cache == null) {
                        TapeDBManager.loadFromDiskAsync(this.tapeId);
                        return 0L;
                    }
                }
                catch (Exception e) {
                    return 0L;
                }
                TapeKey thisKey = new TapeKey(data);
                HashSet<TapeKey> simulatedKeys = new HashSet<TapeKey>();
                try {
                    simulatedKeys.addAll(cache.entries.keySet());
                    simulatedKeys.addAll(cache.deltaBuffer.keySet());
                    simulatedKeys.add(thisKey);
                }
                catch (Exception e) {
                    return 0L;
                }
                int simulatedTypeCount = 0;
                try {
                    for (TapeKey key : simulatedKeys) {
                        long existing = cache.entries.getOrDefault(key, StoredEntry.EMPTY).count();
                        long delta = cache.deltaBuffer.getOrDefault(key, 0L);
                        long count = existing + delta;
                        if (key.equals(thisKey)) {
                            count += amount;
                        }
                        if (count <= 0L) continue;
                        ++simulatedTypeCount;
                    }
                }
                catch (Exception e) {
                    return 0L;
                }
                if (simulatedTypeCount > this.typeLimit) {
                    return 0L;
                }
                try {
                    currentBytes = TapeDBManager.getTotalStoredBytes(this.tapeId);
                }
                catch (Exception e) {
                    return 0L;
                }
                long extra = Math.round((double)((long)data.length * amount) * 0.75);
                if (currentBytes + extra > TapeDBManager.getByteLimit(this.tapeId)) {
                    return 0L;
                }
                if (mode == Actionable.MODULATE) {
                    try {
                        TapeDBManager.saveItem(this.tapeId, data, itemKey, amount);
                        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                        server.execute(() -> source.machine().ifPresent(host -> {
                            IGrid grid;
                            IGridNode node = host.getActionableNode();
                            if (node != null && (grid = node.getGrid()) != null) {
                                Set drives = grid.getMachines(DriveBlockEntity.class);
                                block0: for (DriveBlockEntity drive : drives) {
                                    for (int i = 0; i < drive.getCellCount(); ++i) {
                                        ItemStack stackInSlot = drive.getInternalInventory().getStackInSlot(i);
                                        if (stackInSlot.isEmpty() || !(stackInSlot.getItem() instanceof TapeDiskItem)) continue;
                                        ((DriveBlockEntityAccessor)drive).enderdrives$triggerVisualUpdate();
                                        ((DriveBlockEntityAccessor)drive).enderdrives$recalculateIdlePower();
                                        continue block0;
                                    }
                                }
                            }
                        }));
                    }
                    catch (Exception e) {
                        return 0L;
                    }
                }
            }
        }
        catch (Exception topLevel) {
            return 0L;
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long available;
        long toExtract;
        if (this.disabled || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey itemKey = (AEItemKey)what;
        TapeDBManager.TapeDriveCache cache = TapeDBManager.getCacheSafe(this.tapeId);
        if (cache == null) {
            TapeDBManager.loadFromDiskAsync(this.tapeId);
            return 0L;
        }
        TapeKey matchKey = null;
        for (Map.Entry<TapeKey, StoredEntry> entry : cache.entries.entrySet()) {
            StoredEntry stored = entry.getValue();
            if (stored.aeKey() == null || !stored.aeKey().equals((Object)itemKey)) continue;
            matchKey = entry.getKey();
            break;
        }
        if (matchKey == null) {
            ItemStack s = itemKey.toStack();
            s.setCount((int)Math.min(amount, 64L));
            byte[] data = TapeDiskItem.serializeItemStackToBytes(s);
            if (data == null || data.length == 0) {
                return 0L;
            }
            matchKey = new TapeKey(data);
        }
        if ((toExtract = Math.min(available = TapeDBManager.getItemCount(this.tapeId, matchKey.itemBytes()), amount)) > 0L && mode == Actionable.MODULATE) {
            TapeDBManager.saveItem(this.tapeId, matchKey.itemBytes(), itemKey, -toExtract);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            server.execute(() -> source.machine().ifPresent(host -> {
                IGrid grid;
                IGridNode node = host.getActionableNode();
                if (node != null && (grid = node.getGrid()) != null) {
                    Set drives = grid.getMachines(DriveBlockEntity.class);
                    block0: for (DriveBlockEntity drive : drives) {
                        for (int i = 0; i < drive.getCellCount(); ++i) {
                            ItemStack stackInSlot = drive.getInternalInventory().getStackInSlot(i);
                            if (stackInSlot.isEmpty() || !(stackInSlot.getItem() instanceof TapeDiskItem)) continue;
                            ((DriveBlockEntityAccessor)drive).enderdrives$triggerVisualUpdate();
                            ((DriveBlockEntityAccessor)drive).enderdrives$recalculateIdlePower();
                            continue block0;
                        }
                    }
                }
            }));
        }
        return toExtract;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.disabled) {
            return;
        }
        TapeDBManager.TapeDriveCache cache = TapeDBManager.getCacheSafe(this.tapeId);
        if (cache == null) {
            TapeDBManager.loadFromDiskAsync(this.tapeId);
            return;
        }
        HashMap merged = new HashMap();
        cache.entries.forEach((k, v) -> merged.put(k, v.count()));
        cache.deltaBuffer.forEach((k, v) -> merged.merge(k, v, Long::sum));
        for (Map.Entry entry : merged.entrySet()) {
            AEItemKey key;
            long count = (Long)entry.getValue();
            if (count <= 0L || (key = Optional.ofNullable(cache.entries.get(entry.getKey())).map(StoredEntry::aeKey).orElseGet(() -> {
                ItemStack is = TapeDiskItem.deserializeItemStackFromBytes(((TapeKey)entry.getKey()).itemBytes());
                return is.isEmpty() ? null : AEItemKey.of((ItemStack)is);
            })) == null) continue;
            out.add((AEKey)key, count);
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        if (!(what instanceof AEItemKey)) {
            return false;
        }
        AEItemKey itemKey = (AEItemKey)what;
        ItemStack stack = itemKey.toStack();
        Item item = stack.getItem();
        boolean isSpecial = item instanceof ArmorItem || item instanceof SwordItem || item instanceof PickaxeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem || item instanceof ShearsItem || item instanceof FlintAndSteelItem || item instanceof FishingRodItem || item instanceof ShieldItem || stack.getMaxStackSize() == 1;
        return isSpecial;
    }

    private boolean isSpecialItem(ItemStack stack) {
        Item item = stack.getItem();
        return item instanceof ArmorItem || item instanceof SwordItem || item instanceof PickaxeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem || item instanceof ShearsItem || item instanceof FlintAndSteelItem || item instanceof FishingRodItem || item instanceof ShieldItem || stack.getMaxStackSize() == 1;
    }

    public void persist() {
    }

    public Component getDescription() {
        return Component.literal((String)("Tape Disk " + this.tapeId.toString().substring(0, 8)));
    }

    private boolean hasMeaningfulNBT(ItemStack stack) {
        CompoundTag tag = (CompoundTag)stack.save((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess());
        CompoundTag filtered = tag.copy();
        filtered.remove("count");
        filtered.remove("id");
        filtered.remove("damage");
        filtered.remove("repairCost");
        filtered.remove("unbreakable");
        if (filtered.contains("tag") && filtered.getCompound("tag").isEmpty()) {
            filtered.remove("tag");
        }
        return !filtered.isEmpty();
    }

    private boolean passesFilter(AEKey key) {
        ConfigInventory config = CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)this.stack);
        for (int i = 0; i < config.size(); ++i) {
            AEKey filterKey = config.getKey(i);
            if (filterKey == null || !filterKey.equals(key)) continue;
            return true;
        }
        return config.keySet().isEmpty();
    }

    private static Object getDiskLock(UUID id) {
        return DISK_LOCKS.computeIfAbsent(id, k -> new Object());
    }

    public static class Handler
    implements ICellHandler {
        public boolean isCell(ItemStack is) {
            return is != null && is.getItem() instanceof TapeDiskItem;
        }

        @Nullable
        public StorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new TapeDiskInventory(is) : null;
        }
    }
}

