/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.commands;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.core.definitions.AEItems;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sts15.enderdrives.config.serverConfig;
import com.sts15.enderdrives.db.AEKeyCacheEntry;
import com.sts15.enderdrives.db.EnderDBManager;
import com.sts15.enderdrives.db.TapeDBManager;
import com.sts15.enderdrives.inventory.EnderDiskInventory;
import com.sts15.enderdrives.items.EnderDiskItem;
import com.sts15.enderdrives.items.TapeDiskItem;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ModCommands {
    private static final Map<UUID, Integer> pendingBenchmarkRequests = new HashMap<UUID, Integer>();
    private static final Map<UUID, String> pendingClearRequests = new HashMap<UUID, String>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enderdrives").then(Commands.literal((String)"setfreq").then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).executes(ctx -> {
            CommandSourceStack source;
            int freq = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"frequency");
            if (!ModCommands.validateFrequency(freq, source = (CommandSourceStack)ctx.getSource())) {
                return 0;
            }
            ItemStack heldItem = source.getPlayerOrException().getMainHandItem();
            if (heldItem.getItem() instanceof EnderDiskItem) {
                EnderDiskItem.setFrequency(heldItem, freq);
                source.sendSuccess(() -> Component.literal((String)("Frequency set to " + freq)), true);
            } else {
                source.sendFailure((Component)Component.literal((String)"Hold an EnderDisk in your hand."));
            }
            return 1;
        })))).then(Commands.literal((String)"clear").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            builder.suggest("private");
            builder.suggest("team");
            builder.suggest("global");
            return builder.buildFuture();
        }).then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).executes(ctx -> {
            Object scopePrefix;
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = source.getPlayerOrException();
            int frequency = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"frequency");
            if (!ModCommands.validateFrequency(frequency, source)) {
                return 0;
            }
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type").toLowerCase();
            UUID playerId = player.getUUID();
            switch (type) {
                case "private": {
                    scopePrefix = "player_" + String.valueOf(playerId);
                    break;
                }
                case "team": {
                    scopePrefix = "team_" + String.valueOf(playerId);
                    break;
                }
                case "global": {
                    if (!source.hasPermission(4)) {
                        source.sendFailure((Component)Component.literal((String)"\u00a7cYou must be a server operator to clear general channels."));
                        return 0;
                    }
                    scopePrefix = "global";
                    break;
                }
                default: {
                    source.sendFailure((Component)Component.literal((String)"\u00a7cInvalid channel type. Use 'private', 'team', or 'global'."));
                    return 0;
                }
            }
            String key = String.valueOf(playerId) + ":" + type + ":" + frequency;
            if (!key.equals(pendingClearRequests.get(playerId))) {
                pendingClearRequests.put(playerId, key);
                source.sendSuccess(() -> Component.literal((String)("\u00a7c\u26a0 This will permanently delete all items stored in frequency \u00a7e" + frequency + "\u00a7c under the \u00a76" + type + "\u00a7c scope.\n\u00a77If you are sure, run the same command again to confirm.")), false);
                return 1;
            }
            pendingClearRequests.remove(playerId);
            EnderDBManager.clearFrequency((String)scopePrefix, frequency);
            EnderDBManager.commitDatabase();
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Cleared frequency \u00a7b" + frequency + "\u00a7a for scope \u00a76" + type)), true);
            return 1;
        }))))).requires(source -> source.hasPermission(4))).then(Commands.literal((String)"stats").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            source.sendSuccess(() -> Component.literal((String)("EnderDB Stats:\n - DB Entries: " + EnderDBManager.getDatabaseSize() + "\n - Items Written: " + String.valueOf(EnderDBManager.getTotalItemsWritten()) + "\n - Commits: " + String.valueOf(EnderDBManager.getTotalCommits()) + "\n - DB File Size: " + EnderDBManager.getDatabaseFileSizeBytes() + " bytes")), false);
            return 1;
        }))).then(Commands.literal((String)"autobenchmark").then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).executes(ctx -> {
            CommandSourceStack source;
            int frequency = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"frequency");
            if (!ModCommands.validateFrequency(frequency, source = (CommandSourceStack)ctx.getSource())) {
                return 0;
            }
            ServerPlayer player = source.getPlayerOrException();
            UUID playerId = player.getUUID();
            if (!pendingBenchmarkRequests.containsKey(playerId)) {
                pendingBenchmarkRequests.put(playerId, frequency);
                source.sendSuccess(() -> Component.literal((String)("\u00a7b[EnderDrives Autobenchmark]\n\u00a77This command will insert items until \u00a7f2,000,000 \u00a77types are added to the database.\n\u00a77It will automatically stop if server TPS drops below \u00a7c18\u00a77.\n\n\u00a7fOnce the test starts, open an AE2 terminal with an EnderDrive installed at frequency \u00a7a" + frequency + "\u00a7f and scope \u00a7aPrivate\u00a7f.\n\n\u00a7eRe-run \u00a76/enderdrives autobenchmark " + frequency + " \u00a7eto confirm and begin the test.")), false);
                return 1;
            }
            int confirmedFrequency = pendingBenchmarkRequests.get(playerId);
            if (confirmedFrequency != frequency) {
                source.sendFailure((Component)Component.literal((String)"Frequency mismatch. Use the same frequency you confirmed."));
                return 0;
            }
            MinecraftServer server = player.getServer();
            String scopePrefix = "player_" + String.valueOf(player.getUUID());
            int typeCount_check = EnderDBManager.getTypeCount(scopePrefix, frequency);
            if (typeCount_check > 0) {
                source.sendFailure((Component)Component.literal((String)("Frequency " + frequency + " is not empty. Autobenchmark requires a completely empty frequency.")));
                pendingBenchmarkRequests.remove(playerId);
                return 0;
            }
            pendingBenchmarkRequests.remove(playerId);
            Thread t = new Thread(() -> {
                try {
                    int step = (Integer)serverConfig.AUTO_BENCHMARK_STEP.get();
                    int maxSize = (Integer)serverConfig.AUTO_BENCHMARK_MAX_TYPES.get();
                    double minSafeTPS = (Double)serverConfig.AUTO_BENCHMARK_MIN_TPS.get();
                    int bestSize = 0;
                    boolean continueTesting = true;
                    for (int currentSize = ((Integer)serverConfig.AUTO_BENCHMARK_INITIAL_SIZE.get()).intValue(); continueTesting && currentSize <= maxSize; currentSize += step) {
                        EnderDBManager.clearFrequency(scopePrefix, frequency);
                        long insertStart = System.currentTimeMillis();
                        for (int i = 1; i <= currentSize; ++i) {
                            ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
                            paper.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)String.valueOf(i)));
                            AEItemKey key = AEItemKey.of((ItemStack)paper);
                            byte[] serialized = EnderDiskInventory.serializeItemStackToBytes(key.toStack(1));
                            EnderDBManager.saveItem(scopePrefix, frequency, serialized, 1L);
                        }
                        long insertEnd = System.currentTimeMillis();
                        Thread.sleep(((Integer)serverConfig.AUTO_BENCHMARK_MS_SLEEP.get()).intValue());
                        long[] tickTimes = server.getTickTime(Level.OVERWORLD);
                        double avgTick = Arrays.stream(tickTimes).average().orElse(0.0) / 1000000.0;
                        double tps = Math.min(1000.0 / avgTick, 20.0);
                        long queryStart = System.currentTimeMillis();
                        int typeCount = EnderDBManager.getTypeCount(scopePrefix, frequency);
                        long queryEnd = System.currentTimeMillis();
                        long usedMem = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
                        double insertTime = insertEnd - insertStart;
                        double queryTime = queryEnd - queryStart;
                        int finalCurrentSize = currentSize;
                        source.sendSuccess(() -> Component.literal((String)("\u00a7b[AutoBenchmark]\n\u00a77Tested Size: \u00a7a" + finalCurrentSize + " types\n\u00a77Insert: \u00a7e" + insertTime + "ms\n\u00a77Query: \u00a7e" + queryTime + "ms\n\u00a77Types: \u00a7a" + typeCount + "\n\u00a77Memory: \u00a7b" + usedMem + "MB\n\u00a77TPS: \u00a7a" + String.format("%.2f", tps) + " \u00a77| Tick: \u00a7a" + String.format("%.2f", avgTick) + "ms")), false);
                        if (tps >= minSafeTPS) {
                            bestSize = currentSize;
                            continue;
                        }
                        source.sendSuccess(() -> Component.literal((String)("\u00a7c\u26a0 TPS dropped below " + minSafeTPS + ". Stopping.")), false);
                        break;
                    }
                    int finalBestSize = bestSize;
                    source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2705 Best stable entry count: \u00a7b" + finalBestSize + " types")), false);
                    EnderDBManager.clearFrequency(scopePrefix, frequency);
                    EnderDBManager.commitDatabase();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }, "EnderDB-autobenchmark");
            t.setDaemon(true);
            t.start();
            return 1;
        })))).then(Commands.literal((String)"stress").then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2000000)).executes(ctx -> {
            int frequency = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"frequency");
            if (!ModCommands.validateFrequency(frequency, (CommandSourceStack)ctx.getSource())) {
                return 0;
            }
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = source.getPlayerOrException();
            String scopePrefix = "player_" + player.getUUID().toString();
            HashSet<Integer> seenHashes = new HashSet<Integer>();
            int duplicates = 0;
            long insertStart = System.currentTimeMillis();
            for (int i = 1; i <= amount; ++i) {
                ItemStack paper = new ItemStack((ItemLike)Items.PAPER, 1);
                paper.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)String.valueOf(i)));
                AEItemKey key = AEItemKey.of((ItemStack)paper);
                byte[] serialized = EnderDiskInventory.serializeItemStackToBytes(key.toStack(1));
                int hash = Arrays.hashCode(serialized);
                if (!seenHashes.add(hash)) {
                    int finalI = i;
                    source.sendSuccess(() -> Component.literal((String)("Duplicate detected for: " + finalI)), false);
                    ++duplicates;
                }
                EnderDBManager.saveItem(scopePrefix, frequency, serialized, 1L);
            }
            long insertEnd = System.currentTimeMillis();
            int typeCount = EnderDBManager.getTypeCount(scopePrefix, frequency);
            long insertTime = insertEnd - insertStart;
            int finalDuplicates = duplicates;
            source.sendSuccess(() -> Component.literal((String)"Stress test complete on your private channel:"), false);
            source.sendSuccess(() -> Component.literal((String)("Inserted " + amount + " items in " + insertTime + " ms.")), false);
            source.sendSuccess(() -> Component.literal((String)("Unique types: " + typeCount)), false);
            source.sendSuccess(() -> Component.literal((String)("Duplicates: " + finalDuplicates)), false);
            return 1;
        }))))).then(Commands.literal((String)"dumpcell").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            builder.suggest("private");
            builder.suggest("team");
            builder.suggest("global");
            return builder.buildFuture();
        }).then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).executes(ctx -> {
            Object scopePrefix;
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = source.getPlayerOrException();
            int frequency = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"frequency");
            if (!ModCommands.validateFrequency(frequency, source)) {
                return 0;
            }
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type").toLowerCase();
            UUID playerId = player.getUUID();
            switch (type) {
                case "private": {
                    scopePrefix = "player_" + String.valueOf(playerId);
                    break;
                }
                case "team": {
                    scopePrefix = "team_" + String.valueOf(playerId);
                    break;
                }
                case "global": {
                    if (!source.hasPermission(4)) {
                        source.sendFailure((Component)Component.literal((String)"\u00a7cYou must be a server operator to dump global channels."));
                        return 0;
                    }
                    scopePrefix = "global";
                    break;
                }
                default: {
                    source.sendFailure((Component)Component.literal((String)"\u00a7cInvalid channel type. Use 'private', 'team', or 'global'."));
                    return 0;
                }
            }
            List<AEKeyCacheEntry> entries = EnderDBManager.queryItemsByFrequency((String)scopePrefix, frequency);
            if (entries.isEmpty()) {
                source.sendFailure((Component)Component.literal((String)("\u00a7cNo items found in frequency " + frequency + ".")));
                return 0;
            }
            ArrayList<ItemStack> createdCells = new ArrayList<ItemStack>();
            ItemStack currentCell = null;
            BasicCellInventory handler = null;
            long totalInserted = 0L;
            for (AEKeyCacheEntry entry : entries) {
                AEItemKey key = entry.aeKey();
                long remaining = entry.count();
                while (remaining > 0L) {
                    long insertAmount;
                    long inserted;
                    if (handler == null) {
                        currentCell = new ItemStack((ItemLike)AEItems.ITEM_CELL_256K.get());
                        StorageCell inventory = StorageCells.getCellInventory((ItemStack)currentCell, null);
                        if (!(inventory instanceof BasicCellInventory)) {
                            source.sendFailure((Component)Component.literal((String)"\u00a7cFailed to access 256k storage cell."));
                            return 0;
                        }
                        BasicCellInventory h = (BasicCellInventory)inventory;
                        handler = h;
                        createdCells.add(currentCell);
                        int currentDriveIndex = createdCells.size();
                        String prettyType = type.substring(0, 1).toUpperCase() + type.substring(1);
                        MutableComponent customName = Component.literal((String)("EnderDrives " + prettyType + ":" + frequency + " Drive:" + currentDriveIndex));
                        currentCell.set(DataComponents.CUSTOM_NAME, (Object)customName);
                    }
                    if ((inserted = handler.insert((AEKey)key, insertAmount = Math.min(remaining, Integer.MAX_VALUE), Actionable.MODULATE, (IActionSource)new BaseActionSource())) <= 0L) {
                        handler = null;
                        continue;
                    }
                    remaining -= inserted;
                    totalInserted += inserted;
                }
            }
            for (ItemStack c : createdCells) {
                player.getInventory().placeItemBackInInventory(c);
            }
            long finalTotalInserted = totalInserted;
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Dumped \u00a7e" + finalTotalInserted + "\u00a7a items into \u00a7b" + createdCells.size() + "\u00a7a 256k drive(s).")), true);
            source.sendSuccess(() -> Component.literal((String)"\u00a7a\u2714 If drive creation was successful, you can run clear on that frequency now."), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tape").then(Commands.literal((String)"release").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getActiveTapeIds().forEach(uuid -> builder.suggest(uuid.toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String uuidStr = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                if (!TapeDBManager.getActiveTapeIds().contains(uuid)) {
                    source.sendFailure((Component)Component.literal((String)("\u00a7cTape " + String.valueOf(uuid) + " is not currently cached in RAM.")));
                    return 0;
                }
                TapeDBManager.releaseFromRAM(uuid);
                source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Released tape " + String.valueOf(uuid) + " from RAM.")), true);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid UUID format: " + uuidStr)));
                return 0;
            }
        })))).then(Commands.literal((String)"list").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            Set<UUID> cached = TapeDBManager.getActiveTapeIds();
            if (cached.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"\u00a77No tape drives are currently cached in RAM."), false);
                return 1;
            }
            source.sendSuccess(() -> Component.literal((String)"\u00a7bCached Tape Drives:"), false);
            for (UUID id : cached) {
                int typeCount = TapeDBManager.getTypeCount(id);
                source.sendSuccess(() -> Component.literal((String)(" \u00a78- \u00a7f" + id.toString() + " \u00a77| Types: \u00a7a" + typeCount)), false);
            }
            return 1;
        }))).then(Commands.literal((String)"export").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getActiveTapeIds().forEach(uuid -> builder.suggest(uuid.toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String uuidStr = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                boolean success = TapeDBManager.exportToJson(uuid);
                if (!success) {
                    source.sendFailure((Component)Component.literal((String)"\u00a7cFailed to export. Tape might not exist or is corrupted."));
                    return 0;
                }
                source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Exported tape " + String.valueOf(uuid) + " to JSON.")), false);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid UUID format: " + uuidStr)));
                return 0;
            }
        })))).then(Commands.literal((String)"import").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getActiveTapeIds().forEach(uuid -> builder.suggest(uuid.toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String uuidStr = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                boolean success = TapeDBManager.importFromJson(uuid);
                if (!success) {
                    source.sendFailure((Component)Component.literal((String)"\u00a7cFailed to import. File missing or invalid format."));
                    return 0;
                }
                source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Imported tape " + String.valueOf(uuid) + " from JSON.")), false);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid UUID format: " + uuidStr)));
                return 0;
            }
        })))).then(Commands.literal((String)"oldest").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            List<File> files = TapeDBManager.getSortedBinFilesOldestFirst();
            if (files.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"\u00a77No saved tape drives found."), false);
                return 1;
            }
            source.sendSuccess(() -> Component.literal((String)"\u00a7bOldest Tape Drives:"), false);
            for (File f : files) {
                String name = f.getName().replace(".bin", "");
                long lastMod = f.lastModified();
                long size = f.length();
                String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(lastMod));
                source.sendSuccess(() -> Component.literal((String)(" \u00a78- \u00a7f" + name + " \u00a77| Modified: \u00a76" + time + " \u00a77| Size: \u00a7e" + size + " bytes")), false);
            }
            return 1;
        }))).then(Commands.literal((String)"delete").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getSortedBinFilesOldestFirst().forEach(f -> builder.suggest(f.getName().replace(".bin", "")));
            return builder.buildFuture();
        }).executes(ctx -> {
            String uuidStr = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            try {
                boolean success;
                UUID uuid = UUID.fromString(uuidStr);
                if (TapeDBManager.getActiveTapeIds().contains(uuid)) {
                    TapeDBManager.releaseFromRAM(uuid);
                    source.sendSuccess(() -> Component.literal((String)("\u00a7eTape " + String.valueOf(uuid) + " was cached in RAM and has been released.")), false);
                }
                if (!(success = TapeDBManager.deleteTape(uuid))) {
                    source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to delete tape " + String.valueOf(uuid) + ". File may not exist.")));
                    return 0;
                }
                source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Deleted tape " + String.valueOf(uuid) + " from disk.")), true);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid UUID: " + uuidStr)));
                return 0;
            }
        })))).then(Commands.literal((String)"diagnose").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getSortedBinFilesOldestFirst().forEach(f -> builder.suggest(f.getName().replace(".bin", "")));
            return builder.buildFuture();
        }).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String uuidStr = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                File file = TapeDBManager.getDiskFile(uuid);
                if (!file.exists()) {
                    source.sendFailure((Component)Component.literal((String)("\u00a7cNo .bin file exists for tape " + String.valueOf(uuid))));
                    return 0;
                }
                int total = 0;
                int failed = 0;
                long bytes = file.length();
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                    try {
                        while (true) {
                            int len = dis.readInt();
                            byte[] data = new byte[len];
                            dis.readFully(data);
                            dis.readLong();
                            ++total;
                            ItemStack stack = TapeDiskItem.deserializeItemStackFromBytes(data);
                            if (!stack.isEmpty()) continue;
                            ++failed;
                        }
                    }
                    catch (Throwable len) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable) {
                            len.addSuppressed(throwable);
                        }
                        throw len;
                    }
                }
                catch (EOFException dis) {
                }
                catch (IOException e) {
                    source.sendFailure((Component)Component.literal((String)("\u00a7cError while scanning tape file: " + e.getMessage())));
                    return 0;
                }
                source.sendSuccess(() -> Component.literal((String)("\u00a7b[Diagnosis for " + String.valueOf(uuid) + "]")), false);
                int finalTotal = total;
                source.sendSuccess(() -> Component.literal((String)(" \u00a77Total entries: \u00a7a" + finalTotal)), false);
                int finalFailed = failed;
                source.sendSuccess(() -> Component.literal((String)(" \u00a77Malformed: \u00a7c" + finalFailed)), false);
                source.sendSuccess(() -> Component.literal((String)(" \u00a77Size: \u00a7e" + bytes + " bytes")), false);
                if (failed > 0) {
                    source.sendSuccess(() -> Component.literal((String)("\u00a7e\u26a0 Suggest exporting backup with /enderdrives tape export " + String.valueOf(uuid))), false);
                }
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid UUID format: " + uuidStr)));
                return 0;
            }
        })))).then(Commands.literal((String)"diagnose-all").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            List<File> files = TapeDBManager.getSortedBinFilesOldestFirst();
            if (files.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"\u00a77No saved tape drives to verify."), false);
                return 1;
            }
            int badCount = 0;
            for (File file : files) {
                int finalTotal;
                UUID id = UUID.fromString(file.getName().replace(".bin", ""));
                int total = 0;
                int failed = 0;
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                    try {
                        while (true) {
                            int len = dis.readInt();
                            byte[] data = new byte[len];
                            dis.readFully(data);
                            dis.readLong();
                            ++total;
                            ItemStack stack = TapeDiskItem.deserializeItemStackFromBytes(data);
                            if (!stack.isEmpty()) continue;
                            ++failed;
                        }
                    }
                    catch (Throwable len) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable) {
                            len.addSuppressed(throwable);
                        }
                        throw len;
                    }
                }
                catch (EOFException dis) {
                }
                catch (Exception e) {
                    source.sendFailure((Component)Component.literal((String)("\u00a7cError verifying tape " + String.valueOf(id) + ": " + e.getMessage())));
                    continue;
                }
                if (failed > 0) {
                    ++badCount;
                    int finalFailed = failed;
                    finalTotal = total;
                    source.sendSuccess(() -> Component.literal((String)("\u00a7c" + String.valueOf(id) + " \u2014 " + finalFailed + "/" + finalTotal + " entries failed")), false);
                    continue;
                }
                finalTotal = 0;
                source.sendSuccess(() -> Component.literal((String)("\u00a7a" + String.valueOf(id) + " \u2014 OK (" + finalTotal + " entries)")), false);
            }
            int finalBadCount = badCount;
            source.sendSuccess(() -> Component.literal((String)("\u00a7b\u2714 Finished verifying " + files.size() + " tape(s). Bad tapes: \u00a7c" + finalBadCount)), false);
            return 1;
        }))).then(Commands.literal((String)"stats").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            Set<UUID> cached = TapeDBManager.getActiveTapeIds();
            int cachedDrives = cached.size();
            int totalTypes = 0;
            long totalBytes = 0L;
            for (UUID id : cached) {
                totalTypes += TapeDBManager.getTypeCount(id);
                totalBytes += TapeDBManager.getTotalStoredBytes(id);
            }
            long totalFiles = TapeDBManager.getSortedBinFilesOldestFirst().stream().count();
            long totalDiskSize = TapeDBManager.getSortedBinFilesOldestFirst().stream().mapToLong(File::length).sum();
            source.sendSuccess(() -> Component.literal((String)"\u00a7b[EnderDrives Tape Stats]"), false);
            source.sendSuccess(() -> Component.literal((String)(" \u00a77Cached Drives: \u00a7a" + cachedDrives)), false);
            int finalTotalTypes = totalTypes;
            source.sendSuccess(() -> Component.literal((String)(" \u00a77Total Types Cached: \u00a7e" + finalTotalTypes)), false);
            long finalTotalBytes = totalBytes;
            source.sendSuccess(() -> Component.literal((String)(" \u00a77RAM Usage (Est.): \u00a7d" + finalTotalBytes + " bytes")), false);
            source.sendSuccess(() -> Component.literal((String)(" \u00a77Stored .bin Files: \u00a7b" + totalFiles)), false);
            source.sendSuccess(() -> Component.literal((String)(" \u00a77Disk Usage: \u00a76" + totalDiskSize + " bytes")), false);
            return 1;
        }))).then(Commands.literal((String)"cleanup-empty").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            List<File> files = TapeDBManager.getSortedBinFilesOldestFirst();
            int removed = 0;
            for (File file : files) {
                UUID id = UUID.fromString(file.getName().replace(".bin", ""));
                int total = 0;
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                    try {
                        while (true) {
                            int len = dis.readInt();
                            dis.skipBytes(len);
                            dis.readLong();
                            ++total;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (EOFException dis) {
                }
                catch (Exception e) {
                    source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to read tape " + String.valueOf(id) + ": " + e.getMessage())));
                    continue;
                }
                if (total != 0) continue;
                if (TapeDBManager.getActiveTapeIds().contains(id)) {
                    TapeDBManager.releaseFromRAM(id);
                }
                TapeDBManager.deleteTape(id);
                ++removed;
            }
            int finalRemoved = removed;
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Removed \u00a7b" + finalRemoved + "\u00a7a empty tape(s).")), false);
            return 1;
        }))).then(Commands.literal((String)"pin").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getActiveTapeIds().forEach(id -> builder.suggest(id.toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            UUID uuid = UUID.fromString(StringArgumentType.getString((CommandContext)ctx, (String)"uuid"));
            TapeDBManager.pin(uuid);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2714 Tape " + String.valueOf(uuid) + " pinned to RAM.")), true);
            return 1;
        })))).then(Commands.literal((String)"unpin").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getPinnedTapes().forEach(id -> builder.suggest(id.toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            UUID uuid = UUID.fromString(StringArgumentType.getString((CommandContext)ctx, (String)"uuid"));
            TapeDBManager.unpin(uuid);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7e\u2714 Tape " + String.valueOf(uuid) + " unpinned.")), true);
            return 1;
        })))).then(Commands.literal((String)"info").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            TapeDBManager.getSortedBinFilesOldestFirst().forEach(f -> builder.suggest(f.getName().replace(".bin", "")));
            return builder.buildFuture();
        }).executes(ctx -> {
            UUID uuid = UUID.fromString(StringArgumentType.getString((CommandContext)ctx, (String)"uuid"));
            boolean cached = TapeDBManager.getCache(uuid) != null;
            int typeCount = TapeDBManager.getTypeCount(uuid);
            long byteSize = TapeDBManager.getTotalStoredBytes(uuid);
            boolean pinned = TapeDBManager.isPinned(uuid);
            long lastAccessed = cached ? TapeDBManager.getCache((UUID)uuid).lastAccessed : -1L;
            String accessed = lastAccessed > 0L ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(lastAccessed)) : "\u00a77(Not in RAM)";
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7b[Info for Tape " + String.valueOf(uuid) + "]")), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(" \u00a77In RAM: " + (cached ? "\u00a7aYes" : "\u00a7cNo"))), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(" \u00a77Pinned: " + (pinned ? "\u00a7aYes" : "\u00a7cNo"))), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(" \u00a77Types: \u00a7e" + typeCount)), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(" \u00a77Bytes: \u00a7d" + byteSize)), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(" \u00a77Last Accessed: " + accessed)), false);
            return 1;
        })))));
    }

    private static boolean validateFrequency(int freq, CommandSourceStack source) {
        int min = (Integer)serverConfig.FREQ_MIN.get();
        int max = (Integer)serverConfig.FREQ_MAX.get();
        if (freq < min || freq > max) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFrequency must be between \u00a7e" + min + "\u00a7c and \u00a7e" + max + "\u00a7c.")));
            return false;
        }
        return true;
    }
}

