/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.datagen.client;

import com.mrbysco.horsingaround.registry.HorsingRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class HorsingLanguageProvider
extends LanguageProvider {
    public HorsingLanguageProvider(PackOutput packOutput) {
        super(packOutput, "horsingaround", "en_us");
    }

    protected void addTranslations() {
        this.add("key.horsingaround.category", "Horsing Around");
        this.add("key.horsingaround.open_menu", "Open Call Menu");
        this.addSubtitle(HorsingRegistry.CALL, "Calling companion");
        this.add("message.horsingaround.no_tamed_entities", "You don't have any tamed entities added to your list");
        this.add("horsingaround.networking.summon.failed", "Failed to summon tamed entity %s");
        this.add("horsingaround.networking.unlink.failed", "Failed to unlink tamed entity %s");
        this.add("horsingaround.networking.sync.failed", "Failed to sync tamed entities %s");
        this.addConfig("title", "Horsing Around Config", null);
        this.addConfig("General", "General", "General Settings");
        this.addConfig("addOnMount", "Add on Mount", "Add tamed mountable entities to the call list upon mounting [Default: false]");
        this.addConfig("addOnTame", "Add on Tame", "Add mountable entities to the call list upon being tamed [Default: false]");
    }

    public void addSubtitle(DeferredHolder<SoundEvent, SoundEvent> sound, String text) {
        this.addSubtitle((SoundEvent)sound.get(), text);
    }

    public void addSubtitle(SoundEvent sound, String text) {
        String path = "horsingaround.subtitle." + sound.getLocation().getPath();
        this.add(path, text);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("horsingaround.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("horsingaround.configuration." + path + ".tooltip", description);
        }
    }
}

