/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.common.block;

import com.hollingsworth.ars_creo.CreoConfig;
import com.hollingsworth.ars_creo.common.block.StarbuncleWheelBlock;
import com.hollingsworth.ars_creo.common.registry.ModBlockRegistry;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarbuncleWheelTile
extends GeneratingKineticBlockEntity
implements GeoBlockEntity {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StarbuncleWheelTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockRegistry.STARBY_TILE.get(), pos, state);
        this.setLazyTickRate(20);
    }

    public float getGeneratedSpeed() {
        int spd = (Integer)CreoConfig.WHEEL_BASE_SPEED.get();
        Direction direction = (Direction)this.getBlockState().getValue((Property)StarbuncleWheelBlock.FACING);
        if (direction != Direction.UP && direction != Direction.DOWN && this.level.getBlockState(this.getBlockPos().relative(direction.getClockWise())).is(Tags.Blocks.STORAGE_BLOCKS_GOLD)) {
            spd = (Integer)CreoConfig.WHEEL_BONUS_SPEED.get();
        }
        return StarbuncleWheelTile.convertToDirection((float)spd, (Direction)((Direction)this.getBlockState().getValue((Property)HandCrankBlock.FACING)));
    }

    public void lazyTick() {
        super.lazyTick();
        ((StarbuncleWheelBlock)((Object)ModBlockRegistry.STARBY_WHEEL.get())).updateAllSides(this.getBlockState(), this.level, this.worldPosition);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 1, s -> {
            s.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

