/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.MapBackedCodec;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class CodecMap<V extends CodecProvider<? super V>>
implements Codec<V> {
    protected final String name;
    private final BiMap<ResourceLocation, Codec<? extends V>> codecs = HashBiMap.create();
    private final Codec<V> codec;
    @Nullable
    protected Codec<? extends V> defaultCodec;

    public CodecMap(String name) {
        this.name = name;
        this.codec = new MapBackedCodec<V>(this.name, this.codecs, this::getDefaultCodec);
    }

    @Nullable
    public Codec<? extends V> getDefaultCodec() {
        return this.defaultCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCodec(Codec<? extends V> codec) {
        BiMap<ResourceLocation, Codec<? extends V>> biMap = this.codecs;
        synchronized (biMap) {
            if (this.defaultCodec != null) {
                throw new UnsupportedOperationException("Attempted to set the default codec after it has already been set.");
            }
            if (this.getKey(codec) == null) {
                throw new UnsupportedOperationException("Attempted to set the default codec without registering it first.");
            }
            this.defaultCodec = codec;
        }
    }

    public boolean isEmpty() {
        return this.codecs.isEmpty();
    }

    public boolean containsKey(ResourceLocation key) {
        return this.codecs.containsKey((Object)key);
    }

    @Nullable
    public Codec<? extends V> getValue(ResourceLocation key) {
        return (Codec)this.codecs.get((Object)key);
    }

    @Nullable
    public ResourceLocation getKey(Codec<?> codec) {
        return (ResourceLocation)this.codecs.inverse().get(codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ResourceLocation key, Codec<? extends V> codec) {
        BiMap<ResourceLocation, Codec<? extends V>> biMap = this.codecs;
        synchronized (biMap) {
            if (this.codecs.containsKey((Object)key)) {
                throw new UnsupportedOperationException("Attempted to register a " + this.name + " codec with key " + String.valueOf(key) + " but one already exists!");
            }
            if (this.codecs.containsValue(codec)) {
                throw new UnsupportedOperationException("Attempted to register a " + this.name + " codec with key " + String.valueOf(key) + " but it is already registered under the key " + String.valueOf(this.getKey(codec)));
            }
            this.codecs.put((Object)key, codec);
        }
    }

    public final <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
        return this.codec.encode(input, ops, prefix);
    }

    public final <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
        return this.codec.decode(ops, input);
    }
}

