/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.api.IStickAction;
import mrbysco.constructionstick.api.IStickSupplier;
import mrbysco.constructionstick.api.IStickTemplate;
import mrbysco.constructionstick.basics.ModStats;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.stick.supplier.SupplierInventory;
import mrbysco.constructionstick.stick.supplier.SupplierRandom;
import mrbysco.constructionstick.stick.undo.ISnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class StickJob {
    public final Player player;
    public final Level level;
    public final BlockHitResult blockHitResult;
    public final StickOptions options;
    public final ItemStack stick;
    public final ItemStick stickItem;
    private final IStickAction stickAction;
    private final IStickSupplier stickSupplier;
    private List<ISnapshot> placeSnapshots;

    public StickJob(Player player, Level level, BlockHitResult blockHitResult, ItemStack stick) {
        this.player = player;
        this.level = level;
        this.blockHitResult = blockHitResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.stick = stick;
        this.stickItem = (ItemStick)stick.getItem();
        this.options = new StickOptions(stick);
        this.stickSupplier = this.options.random.get() != false ? new SupplierRandom(player, this.options) : new SupplierInventory(player, this.options);
        this.stickAction = ((IStickTemplate)this.options.upgrades.get()).getStickAction();
        this.stickSupplier.getSupply(StickJob.getTargetItem(level, blockHitResult));
    }

    @Nullable
    private static BlockItem getTargetItem(Level level, BlockHitResult rayTraceResult) {
        Item tgitem = level.getBlockState(rayTraceResult.getBlockPos()).getBlock().asItem();
        if (!(tgitem instanceof BlockItem)) {
            return null;
        }
        return (BlockItem)tgitem;
    }

    public void getSnapshots() {
        int limit = Math.min(this.stickItem.remainingDurability(this.stick), this.stickAction.getLimit(this.stick));
        this.placeSnapshots = this.blockHitResult.getType() == HitResult.Type.BLOCK ? this.stickAction.getSnapshots(this.level, this.player, this.blockHitResult, this.stick, this.options, this.stickSupplier, limit) : this.stickAction.getSnapshotsFromAir(this.level, this.player, this.blockHitResult, this.stick, this.options, this.stickSupplier, limit);
    }

    public Set<BlockPos> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public int blockCount() {
        return this.placeSnapshots.size();
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.stick.isEmpty() || this.stickItem.remainingDurability(this.stick) == 0) break;
            if (!snapshot.execute(this.level, this.player, this.blockHitResult)) continue;
            if (this.player.isCreative()) {
                executed.add(snapshot);
            } else if (this.stickSupplier.takeItemStack(snapshot.getRequiredItems()) == 0) {
                executed.add(snapshot);
                this.stickItem.hurtItem(this.stick, 1, (LivingEntity)this.player, EquipmentSlot.MAINHAND);
                snapshot.onSuccess(this.level, this.player);
            } else {
                ConstructionStick.LOGGER.info("Item could not be taken. Remove block: {}", (Object)snapshot.getBlockState().getBlock().toString());
                snapshot.forceRestore(this.level);
            }
            this.player.awardStat(ModStats.USE_STICK_STAT.get());
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            SoundType sound = this.placeSnapshots.getFirst().getBlockState().getSoundType();
            this.level.playSound(null, this.player.blockPosition(), sound.getPlaceSound(), SoundSource.BLOCKS, sound.volume, sound.pitch);
            ConstructionStick.undoHistory.add(this.player, this.level, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }
}

