/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.client.KeybindHandler;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.stick.StickJob;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

public class RenderBlockPreview {
    private StickJob stickJob;
    public Set<BlockPos> undoBlocks;

    @SubscribeEvent
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        Set<BlockPos> blocks;
        if (event.getTarget().getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult target = event.getTarget();
        Entity entity = event.getCamera().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float colorR = 0.0f;
        float colorG = 0.0f;
        float colorB = 0.0f;
        ItemStack stick = StickUtil.holdingStick(player);
        if (stick == null) {
            return;
        }
        if (!KeybindHandler.KEY_SHOW_PREVIOUS.isDown()) {
            if (this.stickJob == null || !RenderBlockPreview.compareRTR(this.stickJob.blockHitResult, target) || !this.stickJob.stick.equals(stick) || this.stickJob.blockCount() < 2) {
                this.stickJob = ItemStick.getStickJob(player, player.level(), target, stick);
            }
            blocks = this.stickJob.getBlockPositions();
        } else {
            blocks = this.undoBlocks;
            colorG = 1.0f;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        VertexConsumer lineBuilder = buffer.getBuffer((RenderType)RenderType.LINES);
        Camera info = event.getCamera();
        double d0 = info.getPosition().x();
        double d1 = info.getPosition().y();
        double d2 = info.getPosition().z();
        for (BlockPos block : blocks) {
            AABB aabb = new AABB(block).move(-d0, -d1, -d2);
            LevelRenderer.renderLineBox((PoseStack)ms, (VertexConsumer)lineBuilder, (AABB)aabb, (float)colorR, (float)colorG, (float)colorB, (float)0.4f);
        }
        event.setCanceled(true);
    }

    public void reset() {
        this.stickJob = null;
    }

    private static boolean compareRTR(BlockHitResult rtr1, BlockHitResult rtr2) {
        return rtr1.getBlockPos().equals((Object)rtr2.getBlockPos()) && rtr1.getDirection().equals((Object)rtr2.getDirection());
    }
}

