/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class DataStorage {
    private static final String STACK_KEYS = "keys";
    private static final String STACK_AMOUNTS = "amts";
    private static final String ITEM_COUNT_TAG = "item_count";
    public static final DataStorage EMPTY = new DataStorage();
    public ListTag stackKeys;
    public long[] stackAmounts;
    public long itemCount;

    public DataStorage() {
        this.stackKeys = new ListTag();
        this.stackAmounts = new long[0];
        this.itemCount = 0L;
    }

    public DataStorage(ListTag stackKeys, long[] stackAmounts, long itemCount) {
        this.stackKeys = stackKeys;
        this.stackAmounts = stackAmounts;
        this.itemCount = itemCount;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.put(STACK_KEYS, (Tag)this.stackKeys);
        nbt.putLongArray(STACK_AMOUNTS, this.stackAmounts);
        if (this.itemCount != 0L) {
            nbt.putLong(ITEM_COUNT_TAG, this.itemCount);
        }
        return nbt;
    }

    public static DataStorage fromNbt(CompoundTag nbt) {
        ListTag stackKeys = nbt.getList(STACK_KEYS, 10);
        long[] stackAmounts = nbt.getLongArray(STACK_AMOUNTS);
        long itemCount = nbt.getLong(ITEM_COUNT_TAG);
        return new DataStorage(stackKeys, stackAmounts, itemCount);
    }
}

