/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.util;

import com.flanks255.pocketstorage.PocketStorage;
import com.flanks255.pocketstorage.inventory.StorageManager;
import com.flanks255.pocketstorage.items.PocketStorageUnit;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class PSUtils {
    @Nonnull
    public static Optional<UUID> getUUID(@Nonnull ItemStack stack) {
        if (stack.has((DataComponentType)PocketStorage.PSU_UUID.get())) {
            return Optional.ofNullable((UUID)stack.get((DataComponentType)PocketStorage.PSU_UUID.get()));
        }
        if (stack.getItem() instanceof PocketStorageUnit && stack.has(DataComponents.CUSTOM_DATA) && ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("UUID")) {
            return Optional.of(((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getUUID("UUID"));
        }
        return Optional.empty();
    }

    public static Set<String> getUUIDSuggestions(CommandContext<CommandSourceStack> commandSource) {
        StorageManager manager = StorageManager.get();
        HashSet<String> list = new HashSet<String>();
        manager.getMap().forEach((uuid, data) -> list.add(uuid.toString()));
        return list;
    }
}

